/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.api.ClassTemplate;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.engine.discovery.predicates.IsTestFactoryMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestTemplateMethod;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

@API(status=API.Status.INTERNAL, since="5.13")
public class TestClassPredicates {
    public final Predicate<Class<?>> isAnnotatedWithNested = testClass -> AnnotationSupport.isAnnotated(testClass, Nested.class);
    public final Predicate<Class<?>> isAnnotatedWithClassTemplate = testClass -> AnnotationSupport.isAnnotated(testClass, ClassTemplate.class);
    public final Predicate<Class<?>> isAnnotatedWithNestedAndValid = candidate -> this.isAnnotatedWithNested.test((Class<?>)candidate) && this.isValidNestedTestClass((Class<?>)candidate);
    public final Predicate<Class<?>> looksLikeNestedOrStandaloneTestClass = candidate -> this.isAnnotatedWithNested.test((Class<?>)candidate) || this.looksLikeIntendedTestClass((Class<?>)candidate);
    public final Predicate<Method> isTestOrTestFactoryOrTestTemplateMethod;
    private final DiscoveryIssueReporter.Condition<Class<?>> isValidNestedTestClass;
    private final DiscoveryIssueReporter.Condition<Class<?>> isValidStandaloneTestClass;

    public TestClassPredicates(DiscoveryIssueReporter issueReporter) {
        this.isTestOrTestFactoryOrTestTemplateMethod = new IsTestMethod(issueReporter).or(new IsTestFactoryMethod(issueReporter)).or(new IsTestTemplateMethod(issueReporter));
        this.isValidNestedTestClass = TestClassPredicates.isNotPrivateUnlessAbstract("@Nested", issueReporter).and(TestClassPredicates.isInner(issueReporter));
        this.isValidStandaloneTestClass = TestClassPredicates.isNotPrivateUnlessAbstract("Test", issueReporter).and(TestClassPredicates.isNotLocal(issueReporter)).and(TestClassPredicates.isNotInner(issueReporter)).and(TestClassPredicates.isNotAnonymous(issueReporter));
    }

    public boolean looksLikeIntendedTestClass(Class<?> candidate) {
        return this.isAnnotatedWithClassTemplate.test(candidate) || this.hasTestOrTestFactoryOrTestTemplateMethods(candidate) || this.hasNestedTests(candidate);
    }

    public boolean isValidNestedTestClass(Class<?> candidate) {
        return this.isValidNestedTestClass.check(candidate) && ModifierSupport.isNotAbstract(candidate);
    }

    public boolean isValidStandaloneTestClass(Class<?> candidate) {
        return this.isValidStandaloneTestClass.check(candidate) && ModifierSupport.isNotAbstract(candidate);
    }

    private boolean hasTestOrTestFactoryOrTestTemplateMethods(Class<?> candidate) {
        return ReflectionUtils.isMethodPresent(candidate, this.isTestOrTestFactoryOrTestTemplateMethod);
    }

    private boolean hasNestedTests(Class<?> candidate) {
        return ReflectionUtils.isNestedClassPresent(candidate, TestClassPredicates.isNotSame(candidate).and(this.isAnnotatedWithNested.or(it -> ReflectionUtils.isInnerClass(it) && this.looksLikeIntendedTestClass((Class<?>)it))));
    }

    private static Predicate<Class<?>> isNotSame(Class<?> candidate) {
        return clazz -> candidate != clazz;
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotPrivateUnlessAbstract(String prefix, DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> ModifierSupport.isNotPrivate(testClass) || ModifierSupport.isAbstract(testClass), testClass -> TestClassPredicates.createIssue(prefix, testClass, "must not be private"));
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotLocal(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> !testClass.isLocalClass(), testClass -> TestClassPredicates.createIssue("Test", testClass, "must not be a local class"));
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isInner(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(ReflectionUtils::isInnerClass, testClass -> {
            if (testClass.getEnclosingClass() == null) {
                return TestClassPredicates.createIssue("@Nested", testClass, "must not be a top-level class");
            }
            return TestClassPredicates.createIssue("@Nested", testClass, "must not be static");
        });
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotInner(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> !ReflectionUtils.isInnerClass(testClass), testClass -> TestClassPredicates.createIssue("Test", testClass, "must not be an inner class unless annotated with @Nested"));
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotAnonymous(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> !testClass.isAnonymousClass(), testClass -> TestClassPredicates.createIssue("Test", testClass, "must not be anonymous"));
    }

    private static DiscoveryIssue createIssue(String prefix, Class<?> testClass, String detailMessage) {
        String message = String.format("%s class '%s' %s. It will not be executed.", prefix, testClass.getName(), detailMessage);
        return DiscoveryIssue.builder(DiscoveryIssue.Severity.WARNING, message).source(ClassSource.from(testClass)).build();
    }
}

