/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.List;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.SelectorResolutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.core.DiscoveryIssueNotifier;

class DiscoveryIssueCollector
implements LauncherDiscoveryListener {
    final List<DiscoveryIssue> issues = new ArrayList<DiscoveryIssue>();

    DiscoveryIssueCollector() {
    }

    @Override
    public void engineDiscoveryStarted(UniqueId engineId) {
        this.issues.clear();
    }

    @Override
    public void selectorProcessed(UniqueId engineId, DiscoverySelector selector, SelectorResolutionResult result) {
        UniqueId uniqueId;
        if (result.getStatus() == SelectorResolutionResult.Status.FAILED) {
            this.issues.add(DiscoveryIssue.builder(DiscoveryIssue.Severity.ERROR, selector + " resolution failed").cause(result.getThrowable()).build());
        } else if (result.getStatus() == SelectorResolutionResult.Status.UNRESOLVED && selector instanceof UniqueIdSelector && (uniqueId = ((UniqueIdSelector)selector).getUniqueId()).hasPrefix(engineId)) {
            this.issues.add(DiscoveryIssue.create(DiscoveryIssue.Severity.ERROR, selector + " could not be resolved"));
        }
    }

    @Override
    public void issueEncountered(UniqueId engineId, DiscoveryIssue issue) {
        this.issues.add(issue);
    }

    DiscoveryIssueNotifier toNotifier() {
        if (this.issues.isEmpty()) {
            return DiscoveryIssueNotifier.NO_ISSUES;
        }
        DiscoveryIssue.Severity criticalSeverity = DiscoveryIssue.Severity.ERROR;
        return DiscoveryIssueNotifier.from(criticalSeverity, this.issues);
    }
}

