/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.engine.DefaultDiscoveryIssue;
import org.junit.platform.engine.TestSource;

@API(status=API.Status.EXPERIMENTAL, since="1.13")
public interface DiscoveryIssue {
    public static DiscoveryIssue create(Severity severity, String message) {
        return DiscoveryIssue.builder(severity, message).build();
    }

    public static Builder builder(Severity severity, String message) {
        return new DefaultDiscoveryIssue.Builder(severity, message);
    }

    public Severity severity();

    public String message();

    public Optional<TestSource> source();

    public Optional<Throwable> cause();

    public static enum Severity {
        NOTICE,
        DEPRECATION,
        WARNING,
        ERROR;

    }

    public static interface Builder {
        default public Builder source(Optional<TestSource> source) {
            source.ifPresent(this::source);
            return this;
        }

        public Builder source(TestSource var1);

        default public Builder cause(Optional<Throwable> cause) {
            cause.ifPresent(this::cause);
            return this;
        }

        public Builder cause(Throwable var1);

        public DiscoveryIssue build();
    }
}

