/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.ArgumentConverter;
import org.junit.jupiter.params.support.FieldContext;
import org.junit.platform.commons.support.conversion.ConversionException;
import org.junit.platform.commons.support.conversion.ConversionSupport;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.0")
public class DefaultArgumentConverter
implements ArgumentConverter {
    public static final DefaultArgumentConverter INSTANCE = new DefaultArgumentConverter();

    private DefaultArgumentConverter() {
    }

    @Override
    public final Object convert(Object source, ParameterContext context) {
        Class<?> targetType = context.getParameter().getType();
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(context.getDeclaringExecutable().getDeclaringClass());
        return this.convert(source, targetType, classLoader);
    }

    @Override
    public final Object convert(Object source, FieldContext context) throws ArgumentConversionException {
        Class<?> targetType = context.getField().getType();
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(context.getField().getDeclaringClass());
        return this.convert(source, targetType, classLoader);
    }

    public final Object convert(Object source, Class<?> targetType, ClassLoader classLoader) {
        if (source == null) {
            if (targetType.isPrimitive()) {
                throw new ArgumentConversionException("Cannot convert null to primitive value of type " + targetType.getTypeName());
            }
            return null;
        }
        if (ReflectionUtils.isAssignableTo(source, targetType)) {
            return source;
        }
        if (source instanceof String) {
            try {
                return this.convert((String)source, targetType, classLoader);
            }
            catch (ConversionException ex) {
                throw new ArgumentConversionException(ex.getMessage(), ex);
            }
        }
        throw new ArgumentConversionException(String.format("No built-in converter for source type %s and target type %s", source.getClass().getTypeName(), targetType.getTypeName()));
    }

    Object convert(String source, Class<?> targetType, ClassLoader classLoader) {
        return ConversionSupport.convert(source, targetType, classLoader);
    }
}

