/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class AttributeValueEscapingWriter
extends Writer {
    private static final Map<Character, String> REPLACEMENTS_IN_ATTRIBUTE_VALUES;
    private final BufferedWriter delegate;
    private boolean whitespaceReplacingEnabled;

    AttributeValueEscapingWriter(BufferedWriter delegate) {
        this.delegate = delegate;
    }

    void setWhitespaceReplacingEnabled(boolean whitespaceReplacingEnabled) {
        this.whitespaceReplacingEnabled = whitespaceReplacingEnabled;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.whitespaceReplacingEnabled) {
            this.delegate.write(cbuf, off, len);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(len * 2);
        for (int i2 = off; i2 < off + len; ++i2) {
            char c = cbuf[i2];
            String replacement = REPLACEMENTS_IN_ATTRIBUTE_VALUES.get(Character.valueOf(c));
            if (replacement != null) {
                stringBuilder.append(replacement);
                continue;
            }
            stringBuilder.append(c);
        }
        this.delegate.write(stringBuilder.toString());
    }

    @Override
    public void write(int c) throws IOException {
        if (this.whitespaceReplacingEnabled) {
            super.write(c);
        } else {
            this.delegate.write(c);
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (this.whitespaceReplacingEnabled) {
            super.write(cbuf);
        } else {
            this.delegate.write(cbuf);
        }
    }

    @Override
    public void write(String str) throws IOException {
        if (this.whitespaceReplacingEnabled) {
            super.write(str);
        } else {
            this.delegate.write(str);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this.whitespaceReplacingEnabled) {
            super.write(str, off, len);
        } else {
            this.delegate.write(str, off, len);
        }
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        if (this.whitespaceReplacingEnabled) {
            return super.append(csq);
        }
        return this.delegate.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (this.whitespaceReplacingEnabled) {
            return super.append(csq, start, end);
        }
        return this.delegate.append(csq, start, end);
    }

    @Override
    public Writer append(char c) throws IOException {
        if (this.whitespaceReplacingEnabled) {
            return super.append(c);
        }
        return this.delegate.append(c);
    }

    public void newLine() throws IOException {
        this.delegate.newLine();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    static {
        HashMap<Character, String> tmp = new HashMap<Character, String>(3);
        tmp.put(Character.valueOf('\n'), "&#10;");
        tmp.put(Character.valueOf('\r'), "&#13;");
        tmp.put(Character.valueOf('\t'), "&#9;");
        REPLACEMENTS_IN_ATTRIBUTE_VALUES = Collections.unmodifiableMap(tmp);
    }
}

