/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.open.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.CompositeTestSource;
import org.junit.platform.engine.support.descriptor.DirectorySource;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.descriptor.PackageSource;
import org.junit.platform.engine.support.descriptor.UriSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.reporting.open.xml.JUnitFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.DocumentWriter;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.NamespaceRegistry;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Attachments;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.CoreFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Infrastructure;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Result;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Sources;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.git.GitFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java.JavaFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.root.Events;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.root.RootFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.Namespace;

@API(status=API.Status.EXPERIMENTAL, since="1.9")
public class OpenTestReportGeneratingListener
implements TestExecutionListener {
    static final String ENABLED_PROPERTY_NAME = "junit.platform.reporting.open.xml.enabled";
    private final AtomicInteger idCounter = new AtomicInteger();
    private final Map<UniqueId, String> inProgressIds = new ConcurrentHashMap<UniqueId, String>();
    private DocumentWriter<Events> eventsFileWriter = DocumentWriter.noop();
    private final Path workingDir;
    private Path outputDir;

    public OpenTestReportGeneratingListener() {
        this(Paths.get(".", new String[0]).toAbsolutePath());
    }

    OpenTestReportGeneratingListener(Path workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        ConfigurationParameters config = testPlan.getConfigurationParameters();
        if (this.isEnabled(config).booleanValue()) {
            NamespaceRegistry namespaceRegistry = NamespaceRegistry.builder(Namespace.REPORTING_CORE).add("e", Namespace.REPORTING_EVENTS).add("git", Namespace.REPORTING_GIT).add("java", Namespace.REPORTING_JAVA).add("junit", JUnitFactory.NAMESPACE, "https://junit.org/junit5/schemas/open-test-reporting/junit-1.9.xsd").build();
            this.outputDir = testPlan.getOutputDirectoryProvider().getRootDirectory();
            Path eventsXml = this.outputDir.resolve("open-test-report.xml");
            try {
                this.eventsFileWriter = Events.createDocumentWriter(namespaceRegistry, eventsXml);
                this.reportInfrastructure();
            }
            catch (Exception e) {
                throw new JUnitException("Failed to initialize XML events file: " + eventsXml, e);
            }
        }
    }

    private Boolean isEnabled(ConfigurationParameters config) {
        return config.getBoolean(ENABLED_PROPERTY_NAME).orElse(false);
    }

    private void reportInfrastructure() {
        this.eventsFileWriter.append(CoreFactory.infrastructure(), infrastructure -> {
            try {
                String hostName = InetAddress.getLocalHost().getHostName();
                infrastructure.append(CoreFactory.hostName(hostName));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            infrastructure.append(CoreFactory.userName(System.getProperty("user.name"))).append(CoreFactory.operatingSystem(System.getProperty("os.name"))).append(CoreFactory.cpuCores(Runtime.getRuntime().availableProcessors())).append(JavaFactory.javaVersion(System.getProperty("java.version"))).append(JavaFactory.fileEncoding(System.getProperty("file.encoding"))).append(JavaFactory.heapSize(), heapSize -> heapSize.withMax(Runtime.getRuntime().maxMemory()));
            this.addGitInfo((Infrastructure)infrastructure);
        });
    }

    private void addGitInfo(Infrastructure infrastructure) {
        boolean gitInstalled = this.exec("git", "--version").isPresent();
        if (gitInstalled) {
            this.exec("git", "config", "--get", "remote.origin.url").filter(StringUtils::isNotBlank).ifPresent(gitUrl -> infrastructure.append(GitFactory.repository(), repository -> repository.withOriginUrl((String)gitUrl)));
            this.exec("git", "rev-parse", "--abbrev-ref", "HEAD").filter(StringUtils::isNotBlank).ifPresent(branch -> infrastructure.append(GitFactory.branch(branch)));
            this.exec("git", "rev-parse", "--verify", "HEAD").filter(StringUtils::isNotBlank).ifPresent(gitCommitHash -> infrastructure.append(GitFactory.commit(gitCommitHash)));
            this.exec("git", "status", "--porcelain").ifPresent(statusOutput -> infrastructure.append(GitFactory.status(statusOutput), status -> status.withClean(statusOutput.isEmpty())));
        }
    }

    /*
     * Exception decompiling
     */
    Optional<String> exec(String ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static BufferedReader newBufferedReader(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream, Charset.defaultCharset()));
    }

    private Process startProcess(String[] command) {
        Process process;
        try {
            process = new ProcessBuilder(new String[0]).directory(this.workingDir.toFile()).command(command).start();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to start process", e);
        }
        return process;
    }

    private static void readAllChars(Reader reader, BiConsumer<char[], Integer> consumer) throws IOException {
        int numChars;
        char[] buffer = new char[1024];
        while ((numChars = reader.read(buffer)) != -1) {
            consumer.accept(buffer, numChars);
        }
    }

    private static String trimAtEnd(StringBuilder value) {
        int endIndex = value.length();
        for (int i2 = value.length() - 1; i2 >= 0; --i2) {
            if (!Character.isWhitespace(value.charAt(i2))) continue;
            --endIndex;
            break;
        }
        return value.substring(0, endIndex);
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        try {
            this.eventsFileWriter.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close XML events file", e);
        }
        finally {
            this.eventsFileWriter = DocumentWriter.noop();
        }
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        String id = String.valueOf(this.idCounter.incrementAndGet());
        this.reportStarted(testIdentifier, id);
        this.eventsFileWriter.append(RootFactory.finished(id, Instant.now()), finished -> finished.append(CoreFactory.result(Result.Status.SKIPPED), result -> {
            if (StringUtils.isNotBlank(reason)) {
                result.append(CoreFactory.reason(reason));
            }
        }));
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        String id = String.valueOf(this.idCounter.incrementAndGet());
        this.inProgressIds.put(testIdentifier.getUniqueIdObject(), id);
        this.reportStarted(testIdentifier, id);
    }

    private void reportStarted(TestIdentifier testIdentifier, String id) {
        this.eventsFileWriter.append(RootFactory.started(id, Instant.now(), testIdentifier.getDisplayName()), started -> {
            testIdentifier.getParentIdObject().ifPresent(parentId -> started.withParentId(this.inProgressIds.get(parentId)));
            started.append(CoreFactory.metadata(), metadata -> {
                if (!testIdentifier.getTags().isEmpty()) {
                    metadata.append(CoreFactory.tags(), tags -> testIdentifier.getTags().forEach(tag -> tags.append(CoreFactory.tag(tag.getName()))));
                }
                metadata.append(JUnitFactory.uniqueId(testIdentifier.getUniqueId())).append(JUnitFactory.legacyReportingName(testIdentifier.getLegacyReportingName())).append(JUnitFactory.type(testIdentifier.getType()));
            });
            testIdentifier.getSource().ifPresent(source -> started.append(CoreFactory.sources(), sources -> this.addTestSource((TestSource)source, (Sources)sources)));
        });
    }

    private void addTestSource(TestSource source, Sources sources) {
        if (source instanceof CompositeTestSource) {
            ((CompositeTestSource)source).getSources().forEach(it -> this.addTestSource((TestSource)it, sources));
        } else if (source instanceof ClassSource) {
            ClassSource classSource = (ClassSource)source;
            sources.append(JavaFactory.classSource(classSource.getClassName()), element -> classSource.getPosition().ifPresent(filePosition -> element.addFilePosition(filePosition.getLine(), filePosition.getColumn())));
        } else if (source instanceof MethodSource) {
            MethodSource methodSource = (MethodSource)source;
            sources.append(JavaFactory.methodSource(methodSource.getClassName(), methodSource.getMethodName()), element -> {
                String methodParameterTypes = methodSource.getMethodParameterTypes();
                if (methodParameterTypes != null) {
                    element.withMethodParameterTypes(methodParameterTypes);
                }
            });
        } else if (source instanceof ClasspathResourceSource) {
            ClasspathResourceSource classpathResourceSource = (ClasspathResourceSource)source;
            sources.append(JavaFactory.classpathResourceSource(classpathResourceSource.getClasspathResourceName()), element -> classpathResourceSource.getPosition().ifPresent(filePosition -> element.addFilePosition(filePosition.getLine(), filePosition.getColumn())));
        } else if (source instanceof PackageSource) {
            sources.append(JavaFactory.packageSource(((PackageSource)source).getPackageName()));
        } else if (source instanceof FileSource) {
            FileSource fileSource = (FileSource)source;
            sources.append(CoreFactory.fileSource(fileSource.getFile()), element -> fileSource.getPosition().ifPresent(filePosition -> element.addFilePosition(filePosition.getLine(), filePosition.getColumn())));
        } else if (source instanceof DirectorySource) {
            sources.append(CoreFactory.directorySource(((DirectorySource)source).getFile()));
        } else if (source instanceof UriSource) {
            sources.append(CoreFactory.uriSource(((UriSource)source).getUri()));
        }
    }

    @Override
    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        String id = this.inProgressIds.get(testIdentifier.getUniqueIdObject());
        this.eventsFileWriter.append(RootFactory.reported(id, Instant.now()), reported -> reported.append(CoreFactory.attachments(), attachments -> {
            Map<String, String> keyValuePairs = entry.getKeyValuePairs();
            if (keyValuePairs.containsKey("stdout") || keyValuePairs.containsKey("stderr")) {
                OpenTestReportGeneratingListener.attachOutput(attachments, entry.getTimestamp(), keyValuePairs.get("stdout"), "stdout");
                OpenTestReportGeneratingListener.attachOutput(attachments, entry.getTimestamp(), keyValuePairs.get("stderr"), "stderr");
            } else {
                attachments.append(CoreFactory.data(entry.getTimestamp()), data -> keyValuePairs.forEach(data::addEntry));
            }
        }));
    }

    private static void attachOutput(Attachments attachments, LocalDateTime timestamp, String content, String source) {
        if (content != null) {
            attachments.append(CoreFactory.output(timestamp), output -> output.withSource(source).withContent(content));
        }
    }

    @Override
    public void fileEntryPublished(TestIdentifier testIdentifier, FileEntry entry) {
        String id = this.inProgressIds.get(testIdentifier.getUniqueIdObject());
        this.eventsFileWriter.append(RootFactory.reported(id, Instant.now()), reported -> reported.append(CoreFactory.attachments(), attachments -> attachments.append(CoreFactory.file(entry.getTimestamp()), file -> {
            file.withPath(this.outputDir.relativize(entry.getPath()).toString());
            entry.getMediaType().ifPresent(file::withMediaType);
        })));
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        String id = this.inProgressIds.remove(testIdentifier.getUniqueIdObject());
        this.eventsFileWriter.append(RootFactory.finished(id, Instant.now()), finished -> finished.append(CoreFactory.result(this.convertStatus(testExecutionResult.getStatus())), result -> testExecutionResult.getThrowable().ifPresent(throwable -> result.append(JavaFactory.throwable(throwable)))));
    }

    private Result.Status convertStatus(TestExecutionResult.Status status) {
        switch (status) {
            case FAILED: {
                return Result.Status.FAILED;
            }
            case SUCCESSFUL: {
                return Result.Status.SUCCESSFUL;
            }
            case ABORTED: {
                return Result.Status.ABORTED;
            }
        }
        throw new JUnitException("Unhandled status: " + (Object)((Object)status));
    }

    private static /* synthetic */ void lambda$exec$9(char[] __, Integer ___) {
    }

    private static /* synthetic */ void lambda$exec$8(StringBuilder output, char[] chars, Integer numChars) {
        output.append(chars, 0, (int)numChars);
    }
}

