/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.jupiter.engine.execution.DefaultParameterContext;
import org.junit.jupiter.engine.execution.ExtensionContextSupplier;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;

@API(status=API.Status.INTERNAL, since="5.9")
public class ParameterResolutionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ParameterResolutionUtils.class);

    public static Object[] resolveParameters(Method method, Optional<Object> target, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        return ParameterResolutionUtils.resolveParameters((Executable)method, target, Optional.empty(), extensionContext, extensionRegistry);
    }

    public static Object[] resolveParameters(Executable executable, Optional<Object> target, Optional<Object> outerInstance, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        return ParameterResolutionUtils.resolveParameters(executable, target, outerInstance, (TestInstantiationAwareExtension __) -> extensionContext, extensionRegistry);
    }

    public static Object[] resolveParameters(Executable executable, Optional<Object> target, Optional<Object> outerInstance, ExtensionContextSupplier extensionContext, ExtensionRegistry extensionRegistry) {
        Preconditions.notNull(target, "target must not be null");
        Parameter[] parameters = executable.getParameters();
        Object[] values = new Object[parameters.length];
        int start = 0;
        if (outerInstance.isPresent()) {
            Preconditions.condition(parameters[0].isImplicit(), "First parameter must be implicit");
            values[0] = outerInstance.get();
            start = 1;
        }
        for (int i2 = start; i2 < parameters.length; ++i2) {
            DefaultParameterContext parameterContext = new DefaultParameterContext(parameters[i2], i2, target);
            values[i2] = ParameterResolutionUtils.resolveParameter(parameterContext, executable, extensionContext, extensionRegistry);
        }
        return values;
    }

    private static Object resolveParameter(ParameterContext parameterContext, Executable executable, ExtensionContextSupplier extensionContext, ExtensionRegistry extensionRegistry) {
        Preconditions.condition(!parameterContext.getParameter().isImplicit(), () -> String.format("Parameter at index %d must not be implicit", parameterContext.getIndex()));
        try {
            List matchingResolvers = extensionRegistry.stream(ParameterResolver.class).filter(resolver -> resolver.supportsParameter(parameterContext, extensionContext.get((TestInstantiationAwareExtension)resolver))).collect(Collectors.toList());
            if (matchingResolvers.isEmpty()) {
                throw new ParameterResolutionException(String.format("No ParameterResolver registered for parameter [%s] in %s [%s].", parameterContext.getParameter(), ParameterResolutionUtils.asLabel(executable), executable.toGenericString()));
            }
            if (matchingResolvers.size() > 1) {
                String resolvers = matchingResolvers.stream().map(StringUtils::defaultToString).collect(Collectors.joining(", "));
                throw new ParameterResolutionException(String.format("Discovered multiple competing ParameterResolvers for parameter [%s] in %s [%s]: %s", parameterContext.getParameter(), ParameterResolutionUtils.asLabel(executable), executable.toGenericString(), resolvers));
            }
            ParameterResolver resolver2 = (ParameterResolver)matchingResolvers.get(0);
            Object value = resolver2.resolveParameter(parameterContext, extensionContext.get(resolver2));
            ParameterResolutionUtils.validateResolvedType(parameterContext.getParameter(), value, executable, resolver2);
            logger.trace(() -> String.format("ParameterResolver [%s] resolved a value of type [%s] for parameter [%s] in %s [%s].", resolver2.getClass().getName(), value != null ? value.getClass().getName() : null, parameterContext.getParameter(), ParameterResolutionUtils.asLabel(executable), executable.toGenericString()));
            return value;
        }
        catch (ParameterResolutionException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            String message = String.format("Failed to resolve parameter [%s] in %s [%s]", parameterContext.getParameter(), ParameterResolutionUtils.asLabel(executable), executable.toGenericString());
            if (StringUtils.isNotBlank(throwable.getMessage())) {
                message = message + ": " + throwable.getMessage();
            }
            throw new ParameterResolutionException(message, throwable);
        }
    }

    private static void validateResolvedType(Parameter parameter, Object value, Executable executable, ParameterResolver resolver) {
        Class<?> type = parameter.getType();
        if (!ReflectionUtils.isAssignableTo(value, type)) {
            String message = value == null && type.isPrimitive() ? String.format("ParameterResolver [%s] resolved a null value for parameter [%s] in %s [%s], but a primitive of type [%s] is required.", resolver.getClass().getName(), parameter, ParameterResolutionUtils.asLabel(executable), executable.toGenericString(), type.getName()) : String.format("ParameterResolver [%s] resolved a value of type [%s] for parameter [%s] in %s [%s], but a value assignment compatible with [%s] is required.", resolver.getClass().getName(), value != null ? value.getClass().getName() : null, parameter, ParameterResolutionUtils.asLabel(executable), executable.toGenericString(), type.getName());
            throw new ParameterResolutionException(message);
        }
    }

    private static String asLabel(Executable executable) {
        return executable instanceof Constructor ? "constructor" : "method";
    }
}

