/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.List;
import java.util.function.Consumer;
import org.junit.jupiter.api.ClassDescriptor;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.TestClassOrder;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterEngineDescriptor;
import org.junit.jupiter.engine.discovery.AbstractOrderingVisitor;
import org.junit.jupiter.engine.discovery.DefaultClassDescriptor;
import org.junit.jupiter.engine.discovery.DefaultClassOrdererContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.LruCache;
import org.junit.platform.engine.TestDescriptor;

class ClassOrderingVisitor
extends AbstractOrderingVisitor {
    private final LruCache<ClassBasedTestDescriptor, AbstractOrderingVisitor.DescriptorWrapperOrderer<DefaultClassDescriptor>> ordererCache = new LruCache(10);
    private final JupiterConfiguration configuration;
    private final AbstractOrderingVisitor.DescriptorWrapperOrderer<DefaultClassDescriptor> globalOrderer;

    ClassOrderingVisitor(JupiterConfiguration configuration) {
        this.configuration = configuration;
        this.globalOrderer = this.createGlobalOrderer(configuration);
    }

    @Override
    public void visit(TestDescriptor testDescriptor) {
        this.doWithMatchingDescriptor(JupiterEngineDescriptor.class, testDescriptor, this::orderTopLevelClasses, descriptor -> "Failed to order top-level classes");
        this.doWithMatchingDescriptor(ClassBasedTestDescriptor.class, testDescriptor, this::orderNestedClasses, descriptor -> "Failed to order nested classes for " + descriptor.getTestClass());
    }

    @Override
    protected boolean shouldNonMatchingDescriptorsComeBeforeOrderedOnes() {
        return true;
    }

    private void orderTopLevelClasses(JupiterEngineDescriptor engineDescriptor) {
        this.orderChildrenTestDescriptors(engineDescriptor, ClassBasedTestDescriptor.class, DefaultClassDescriptor::new, this.globalOrderer);
    }

    private void orderNestedClasses(ClassBasedTestDescriptor descriptor) {
        this.orderChildrenTestDescriptors(descriptor, ClassBasedTestDescriptor.class, DefaultClassDescriptor::new, this.createAndCacheClassLevelOrderer(descriptor));
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<DefaultClassDescriptor> createGlobalOrderer(JupiterConfiguration configuration) {
        ClassOrderer classOrderer = configuration.getDefaultTestClassOrderer().orElse(null);
        return classOrderer == null ? AbstractOrderingVisitor.DescriptorWrapperOrderer.noop() : this.createDescriptorWrapperOrderer(classOrderer);
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<DefaultClassDescriptor> createAndCacheClassLevelOrderer(ClassBasedTestDescriptor classBasedTestDescriptor) {
        AbstractOrderingVisitor.DescriptorWrapperOrderer<DefaultClassDescriptor> orderer = this.createClassLevelOrderer(classBasedTestDescriptor);
        this.ordererCache.put(classBasedTestDescriptor, orderer);
        return orderer;
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<DefaultClassDescriptor> createClassLevelOrderer(ClassBasedTestDescriptor classBasedTestDescriptor) {
        return AnnotationSupport.findAnnotation(classBasedTestDescriptor.getTestClass(), TestClassOrder.class).map(TestClassOrder::value).map(x$0 -> (ClassOrderer)ReflectionSupport.newInstance(x$0, new Object[0])).map(this::createDescriptorWrapperOrderer).orElseGet(() -> {
            Object parent = classBasedTestDescriptor.getParent().orElse(null);
            if (parent instanceof ClassBasedTestDescriptor) {
                ClassBasedTestDescriptor parentClassTestDescriptor = parent;
                AbstractOrderingVisitor.DescriptorWrapperOrderer<DefaultClassDescriptor> cacheEntry = (AbstractOrderingVisitor.DescriptorWrapperOrderer<DefaultClassDescriptor>)this.ordererCache.get(parentClassTestDescriptor);
                return cacheEntry != null ? cacheEntry : this.createClassLevelOrderer(parentClassTestDescriptor);
            }
            return this.globalOrderer;
        });
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<DefaultClassDescriptor> createDescriptorWrapperOrderer(ClassOrderer classOrderer) {
        Consumer orderingAction = classDescriptors -> classOrderer.orderClasses(new DefaultClassOrdererContext((List<? extends ClassDescriptor>)classDescriptors, this.configuration));
        AbstractOrderingVisitor.MessageGenerator descriptorsAddedMessageGenerator = number -> String.format("ClassOrderer [%s] added %s ClassDescriptor(s) which will be ignored.", classOrderer.getClass().getName(), number);
        AbstractOrderingVisitor.MessageGenerator descriptorsRemovedMessageGenerator = number -> String.format("ClassOrderer [%s] removed %s ClassDescriptor(s) which will be retained with arbitrary ordering.", classOrderer.getClass().getName(), number);
        return new AbstractOrderingVisitor.DescriptorWrapperOrderer<DefaultClassDescriptor>(orderingAction, descriptorsAddedMessageGenerator, descriptorsRemovedMessageGenerator);
    }
}

