/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;
import org.junit.platform.launcher.TestIdentifier;

@API(status=API.Status.STABLE, since="1.0")
public class TestPlan {
    private final Set<TestIdentifier> roots = Collections.synchronizedSet(new LinkedHashSet(4));
    private final Map<UniqueId, Set<TestIdentifier>> children = new ConcurrentHashMap<UniqueId, Set<TestIdentifier>>(32);
    private final Map<UniqueId, TestIdentifier> allIdentifiers = new ConcurrentHashMap<UniqueId, TestIdentifier>(32);
    private final boolean containsTests;
    private final ConfigurationParameters configurationParameters;
    private final OutputDirectoryProvider outputDirectoryProvider;

    @API(status=API.Status.INTERNAL, since="1.12")
    public static TestPlan from(Collection<TestDescriptor> engineDescriptors, ConfigurationParameters configurationParameters, OutputDirectoryProvider outputDirectoryProvider) {
        Preconditions.notNull(engineDescriptors, "Cannot create TestPlan from a null collection of TestDescriptors");
        Preconditions.notNull(configurationParameters, "Cannot create TestPlan from null ConfigurationParameters");
        TestPlan testPlan = new TestPlan(engineDescriptors.stream().anyMatch(TestDescriptor::containsTests), configurationParameters, outputDirectoryProvider);
        TestDescriptor.Visitor visitor = descriptor -> testPlan.addInternal(TestIdentifier.from(descriptor));
        engineDescriptors.forEach(engineDescriptor -> engineDescriptor.accept(visitor));
        return testPlan;
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    protected TestPlan(boolean containsTests, ConfigurationParameters configurationParameters, OutputDirectoryProvider outputDirectoryProvider) {
        this.containsTests = containsTests;
        this.configurationParameters = configurationParameters;
        this.outputDirectoryProvider = outputDirectoryProvider;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.4")
    public void add(TestIdentifier testIdentifier) {
        throw new JUnitException("Unsupported attempt to modify the TestPlan was detected. Please contact your IDE/tool vendor and request a fix or downgrade to JUnit 5.7.x (see https://github.com/junit-team/junit5/issues/1732 for details).");
    }

    @API(status=API.Status.INTERNAL, since="1.8")
    public void addInternal(TestIdentifier testIdentifier) {
        Preconditions.notNull(testIdentifier, "testIdentifier must not be null");
        this.allIdentifiers.put(testIdentifier.getUniqueIdObject(), testIdentifier);
        if (!testIdentifier.getParentIdObject().isPresent()) {
            this.roots.add(testIdentifier);
            return;
        }
        UniqueId parentId = testIdentifier.getParentIdObject().get();
        if (!this.allIdentifiers.containsKey(parentId)) {
            this.roots.add(testIdentifier);
            return;
        }
        Set directChildren = this.children.computeIfAbsent(parentId, key -> Collections.synchronizedSet(new LinkedHashSet(16)));
        directChildren.add(testIdentifier);
    }

    public Set<TestIdentifier> getRoots() {
        return Collections.unmodifiableSet(this.roots);
    }

    public Optional<TestIdentifier> getParent(TestIdentifier child) {
        Preconditions.notNull(child, "child must not be null");
        return child.getParentIdObject().map(this::getTestIdentifier);
    }

    public Set<TestIdentifier> getChildren(TestIdentifier parent) {
        Preconditions.notNull(parent, "parent must not be null");
        return this.getChildren(parent.getUniqueIdObject());
    }

    @API(status=API.Status.DEPRECATED, since="1.10")
    @Deprecated
    public Set<TestIdentifier> getChildren(String parentId) {
        Preconditions.notBlank(parentId, "parent ID must not be null or blank");
        return this.getChildren(UniqueId.parse(parentId));
    }

    @API(status=API.Status.MAINTAINED, since="1.10")
    public Set<TestIdentifier> getChildren(UniqueId parentId) {
        return this.children.containsKey(parentId) ? Collections.unmodifiableSet(this.children.get(parentId)) : Collections.emptySet();
    }

    @API(status=API.Status.DEPRECATED, since="1.10")
    @Deprecated
    public TestIdentifier getTestIdentifier(String uniqueId) throws PreconditionViolationException {
        Preconditions.notBlank(uniqueId, "unique ID must not be null or blank");
        return this.getTestIdentifier(UniqueId.parse(uniqueId));
    }

    @API(status=API.Status.MAINTAINED, since="1.10")
    public TestIdentifier getTestIdentifier(UniqueId uniqueId) {
        Preconditions.notNull(uniqueId, () -> "uniqueId must not be null");
        return Preconditions.notNull(this.allIdentifiers.get(uniqueId), () -> "No TestIdentifier with unique ID [" + uniqueId + "] has been added to this TestPlan.");
    }

    public long countTestIdentifiers(Predicate<? super TestIdentifier> predicate) {
        Preconditions.notNull(predicate, "Predicate must not be null");
        return this.allIdentifiers.values().stream().filter(predicate).count();
    }

    public Set<TestIdentifier> getDescendants(TestIdentifier parent) {
        Preconditions.notNull(parent, "parent must not be null");
        LinkedHashSet<TestIdentifier> result = new LinkedHashSet<TestIdentifier>(16);
        Set<TestIdentifier> children = this.getChildren(parent);
        result.addAll(children);
        for (TestIdentifier child : children) {
            result.addAll(this.getDescendants(child));
        }
        return Collections.unmodifiableSet(result);
    }

    public boolean containsTests() {
        return this.containsTests;
    }

    @API(status=API.Status.MAINTAINED, since="1.8")
    public ConfigurationParameters getConfigurationParameters() {
        return this.configurationParameters;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.12")
    public OutputDirectoryProvider getOutputDirectoryProvider() {
        return this.outputDirectoryProvider;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.10")
    public void accept(Visitor visitor) {
        this.getRoots().forEach(it -> this.accept(visitor, (TestIdentifier)it));
    }

    private void accept(Visitor visitor, TestIdentifier testIdentifier) {
        if (testIdentifier.isContainer()) {
            visitor.preVisitContainer(testIdentifier);
        }
        visitor.visit(testIdentifier);
        this.getChildren(testIdentifier).forEach(it -> this.accept(visitor, (TestIdentifier)it));
        if (testIdentifier.isContainer()) {
            visitor.postVisitContainer(testIdentifier);
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.10")
    public static interface Visitor {
        default public void preVisitContainer(TestIdentifier testIdentifier) {
        }

        default public void visit(TestIdentifier testIdentifier) {
        }

        default public void postVisitContainer(TestIdentifier testIdentifier) {
        }
    }
}

