/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.platform.commons.JUnitException;

class CustomContextClassLoaderExecutor {
    private final Optional<ClassLoader> customClassLoader;

    CustomContextClassLoaderExecutor(Optional<ClassLoader> customClassLoader) {
        this.customClassLoader = customClassLoader;
    }

    <T> T invoke(Supplier<T> supplier) {
        if (this.customClassLoader.isPresent()) {
            return this.replaceThreadContextClassLoaderAndInvoke(this.customClassLoader.get(), supplier);
        }
        return supplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T replaceThreadContextClassLoaderAndInvoke(ClassLoader customClassLoader, Supplier<T> supplier) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(customClassLoader);
            T t = supplier.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            if (customClassLoader instanceof AutoCloseable) {
                CustomContextClassLoaderExecutor.close((AutoCloseable)((Object)customClassLoader));
            }
        }
    }

    private static void close(AutoCloseable customClassLoader) {
        try {
            customClassLoader.close();
        }
        catch (Exception e) {
            throw new JUnitException("Failed to close custom class loader", e);
        }
    }
}

