/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePreDestroyCallback;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ExtensionUtils;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodExtensionContext;
import org.junit.jupiter.engine.execution.AfterEachMethodAdapter;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.execution.InterceptingExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.jupiter.engine.support.JupiterThrowableCollectorFactory;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

@API(status=API.Status.INTERNAL, since="5.0")
public class TestMethodTestDescriptor
extends MethodBasedTestDescriptor {
    public static final String SEGMENT_TYPE = "method";
    private static final InterceptingExecutableInvoker executableInvoker = new InterceptingExecutableInvoker();
    private static final InterceptingExecutableInvoker.ReflectiveInterceptorCall<Method, Void> defaultInterceptorCall = InterceptingExecutableInvoker.ReflectiveInterceptorCall.ofVoidMethod(InvocationInterceptor::interceptTestMethod);
    private final InterceptingExecutableInvoker.ReflectiveInterceptorCall<Method, Void> interceptorCall;

    public TestMethodTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod, Supplier<List<Class<?>>> enclosingInstanceTypes, JupiterConfiguration configuration) {
        super(uniqueId, testClass, testMethod, enclosingInstanceTypes, configuration);
        this.interceptorCall = defaultInterceptorCall;
    }

    TestMethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Method testMethod, JupiterConfiguration configuration, InterceptingExecutableInvoker.ReflectiveInterceptorCall<Method, Void> interceptorCall) {
        super(uniqueId, displayName, testClass, testMethod, configuration);
        this.interceptorCall = interceptorCall;
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = this.populateNewExtensionRegistry(context);
        ThrowableCollector throwableCollector = JupiterThrowableCollectorFactory.createThrowableCollector();
        MethodExtensionContext extensionContext = new MethodExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, context.getConfiguration(), registry, throwableCollector);
        JupiterEngineExecutionContext newContext = context.extend().withExtensionRegistry(registry).withExtensionContext(extensionContext).withThrowableCollector(throwableCollector).build();
        throwableCollector.execute(() -> {
            TestInstances testInstances = newContext.getTestInstancesProvider().getTestInstances(newContext);
            extensionContext.setTestInstances(testInstances);
        });
        return newContext;
    }

    protected MutableExtensionRegistry populateNewExtensionRegistry(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = ExtensionUtils.populateNewExtensionRegistryFromExtendWithAnnotation(context.getExtensionRegistry(), this.getTestMethod());
        ExtensionUtils.registerExtensionsFromExecutableParameters(registry, this.getTestMethod());
        return registry;
    }

    @Override
    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        this.invokeBeforeEachCallbacks(context);
        if (throwableCollector.isEmpty()) {
            this.invokeBeforeEachMethods(context);
            if (throwableCollector.isEmpty()) {
                this.invokeBeforeTestExecutionCallbacks(context);
                if (throwableCollector.isEmpty()) {
                    this.invokeTestMethod(context, dynamicTestExecutor);
                }
                this.invokeAfterTestExecutionCallbacks(context);
            }
            this.invokeAfterEachMethods(context);
        }
        this.invokeAfterEachCallbacks(context);
        return context;
    }

    @Override
    public void cleanUp(JupiterEngineExecutionContext context) throws Exception {
        if (this.isPerMethodLifecycle(context) && context.getExtensionContext().getTestInstance().isPresent()) {
            this.invokeTestInstancePreDestroyCallbacks(context);
        }
        context.getThrowableCollector().execute(() -> super.cleanUp(context));
        context.getThrowableCollector().assertEmpty();
    }

    private boolean isPerMethodLifecycle(JupiterEngineExecutionContext context) {
        return context.getExtensionContext().getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_CLASS) == TestInstance.Lifecycle.PER_METHOD;
    }

    private void invokeBeforeEachCallbacks(JupiterEngineExecutionContext context) {
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(BeforeEachCallback.class, context, (callback, extensionContext) -> callback.beforeEach(extensionContext));
    }

    private void invokeBeforeEachMethods(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = context.getExtensionRegistry();
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(BeforeEachMethodAdapter.class, context, (adapter, extensionContext) -> {
            try {
                adapter.invokeBeforeEachMethod(extensionContext, registry);
            }
            catch (Throwable throwable) {
                this.invokeBeforeEachExecutionExceptionHandlers(extensionContext, registry, throwable);
            }
        });
    }

    private void invokeBeforeEachExecutionExceptionHandlers(ExtensionContext context, ExtensionRegistry registry, Throwable throwable) {
        this.invokeExecutionExceptionHandlers(LifecycleMethodExecutionExceptionHandler.class, registry, throwable, (handler, handledThrowable) -> handler.handleBeforeEachMethodExecutionException(context, handledThrowable));
    }

    private void invokeBeforeTestExecutionCallbacks(JupiterEngineExecutionContext context) {
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(BeforeTestExecutionCallback.class, context, (callback, extensionContext) -> callback.beforeTestExecution(extensionContext));
    }

    private <T extends Extension> void invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(Class<T> type, JupiterEngineExecutionContext context, CallbackInvoker<T> callbackInvoker) {
        MutableExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        for (Extension callback : registry.getExtensions(type)) {
            throwableCollector.execute(() -> callbackInvoker.invoke(callback, extensionContext));
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    protected void invokeTestMethod(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) {
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        throwableCollector.execute(() -> {
            try {
                Method testMethod = this.getTestMethod();
                Object instance = extensionContext.getRequiredTestInstance();
                executableInvoker.invoke(testMethod, instance, extensionContext, (ExtensionRegistry)context.getExtensionRegistry(), this.interceptorCall);
            }
            catch (Throwable throwable) {
                UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
                this.invokeTestExecutionExceptionHandlers(context.getExtensionRegistry(), extensionContext, throwable);
            }
        });
    }

    private void invokeTestExecutionExceptionHandlers(ExtensionRegistry registry, ExtensionContext context, Throwable throwable) {
        this.invokeExecutionExceptionHandlers(TestExecutionExceptionHandler.class, registry, throwable, (handler, handledThrowable) -> handler.handleTestExecutionException(context, handledThrowable));
    }

    private void invokeAfterTestExecutionCallbacks(JupiterEngineExecutionContext context) {
        this.invokeAllAfterMethodsOrCallbacks(AfterTestExecutionCallback.class, context, (callback, extensionContext) -> callback.afterTestExecution(extensionContext));
    }

    private void invokeAfterEachMethods(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = context.getExtensionRegistry();
        this.invokeAllAfterMethodsOrCallbacks(AfterEachMethodAdapter.class, context, (adapter, extensionContext) -> {
            try {
                adapter.invokeAfterEachMethod(extensionContext, registry);
            }
            catch (Throwable throwable) {
                this.invokeAfterEachExecutionExceptionHandlers(extensionContext, registry, throwable);
            }
        });
    }

    private void invokeAfterEachExecutionExceptionHandlers(ExtensionContext context, ExtensionRegistry registry, Throwable throwable) {
        this.invokeExecutionExceptionHandlers(LifecycleMethodExecutionExceptionHandler.class, registry, throwable, (handler, handledThrowable) -> handler.handleAfterEachMethodExecutionException(context, handledThrowable));
    }

    private void invokeAfterEachCallbacks(JupiterEngineExecutionContext context) {
        this.invokeAllAfterMethodsOrCallbacks(AfterEachCallback.class, context, (callback, extensionContext) -> callback.afterEach(extensionContext));
    }

    private void invokeTestInstancePreDestroyCallbacks(JupiterEngineExecutionContext context) {
        this.invokeAllAfterMethodsOrCallbacks(TestInstancePreDestroyCallback.class, context, TestInstancePreDestroyCallback::preDestroyTestInstance);
    }

    private <T extends Extension> void invokeAllAfterMethodsOrCallbacks(Class<T> type, JupiterEngineExecutionContext context, CallbackInvoker<T> callbackInvoker) {
        MutableExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        CollectionUtils.forEachInReverseOrder(registry.getExtensions(type), callback -> throwableCollector.execute(() -> callbackInvoker.invoke(callback, extensionContext)));
    }

    @Override
    public void nodeFinished(JupiterEngineExecutionContext context, TestDescriptor descriptor, TestExecutionResult result) {
        if (context != null) {
            ExtensionContext extensionContext = context.getExtensionContext();
            TestExecutionResult.Status status = result.getStatus();
            this.invokeTestWatchers(context, true, watcher -> {
                switch (status) {
                    case SUCCESSFUL: {
                        watcher.testSuccessful(extensionContext);
                        break;
                    }
                    case ABORTED: {
                        watcher.testAborted(extensionContext, result.getThrowable().orElse(null));
                        break;
                    }
                    case FAILED: {
                        watcher.testFailed(extensionContext, result.getThrowable().orElse(null));
                    }
                }
            });
        }
    }

    @FunctionalInterface
    private static interface CallbackInvoker<T extends Extension> {
        public void invoke(T var1, ExtensionContext var2) throws Throwable;
    }
}

