/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.console.shadow.picocli.CommandLine;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UriSelector;

class SelectorConverter {
    SelectorConverter() {
    }

    static class Identifier
    implements CommandLine.ITypeConverter<DiscoverySelectorIdentifier> {
        Identifier() {
        }

        @Override
        public DiscoverySelectorIdentifier convert(String value) {
            return DiscoverySelectorIdentifier.parse(value);
        }
    }

    static class Iteration
    implements CommandLine.ITypeConverter<IterationSelector> {
        Iteration() {
        }

        @Override
        public IterationSelector convert(String value) {
            DiscoverySelectorIdentifier identifier = DiscoverySelectorIdentifier.create("iteration", value);
            return (IterationSelector)DiscoverySelectors.parse(identifier).orElseThrow(() -> new PreconditionViolationException("Invalid format: Failed to parse selector"));
        }
    }

    static class ClasspathResource
    implements CommandLine.ITypeConverter<ClasspathResourceSelector> {
        ClasspathResource() {
        }

        @Override
        public ClasspathResourceSelector convert(String value) {
            return DiscoverySelectors.selectClasspathResource(value);
        }
    }

    static class Method
    implements CommandLine.ITypeConverter<MethodSelector> {
        Method() {
        }

        @Override
        public MethodSelector convert(String value) {
            return DiscoverySelectors.selectMethod(value);
        }
    }

    static class Class
    implements CommandLine.ITypeConverter<ClassSelector> {
        Class() {
        }

        @Override
        public ClassSelector convert(String value) {
            return DiscoverySelectors.selectClass(value);
        }
    }

    static class Package
    implements CommandLine.ITypeConverter<PackageSelector> {
        Package() {
        }

        @Override
        public PackageSelector convert(String value) {
            return DiscoverySelectors.selectPackage(value);
        }
    }

    static class Directory
    implements CommandLine.ITypeConverter<DirectorySelector> {
        Directory() {
        }

        @Override
        public DirectorySelector convert(String value) {
            return DiscoverySelectors.selectDirectory(value);
        }
    }

    static class File
    implements CommandLine.ITypeConverter<FileSelector> {
        File() {
        }

        @Override
        public FileSelector convert(String value) {
            return DiscoverySelectors.selectFile(value);
        }
    }

    static class Uri
    implements CommandLine.ITypeConverter<UriSelector> {
        Uri() {
        }

        @Override
        public UriSelector convert(String value) {
            return DiscoverySelectors.selectUri(value);
        }
    }

    static class Module
    implements CommandLine.ITypeConverter<ModuleSelector> {
        Module() {
        }

        @Override
        public ModuleSelector convert(String value) {
            return DiscoverySelectors.selectModule(value);
        }
    }
}

