/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.ColorPalette;
import org.junit.platform.console.tasks.DetailsPrintingListener;
import org.junit.platform.console.tasks.TreeNode;
import org.junit.platform.console.tasks.TreePrinter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class TreePrintingListener
implements DetailsPrintingListener {
    private final Map<UniqueId, TreeNode> nodesByUniqueId = new ConcurrentHashMap<UniqueId, TreeNode>();
    private TreeNode root;
    private final TreePrinter treePrinter;

    TreePrintingListener(PrintWriter out, ColorPalette colorPalette, Theme theme) {
        this.treePrinter = new TreePrinter(out, theme, colorPalette);
    }

    private void addNode(TestIdentifier testIdentifier, TreeNode node) {
        this.nodesByUniqueId.put(testIdentifier.getUniqueIdObject(), node);
        testIdentifier.getParentIdObject().map(this.nodesByUniqueId::get).orElse(this.root).addChild(node);
    }

    private TreeNode getNode(TestIdentifier testIdentifier) {
        return this.nodesByUniqueId.get(testIdentifier.getUniqueIdObject());
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.root = new TreeNode(testPlan.toString());
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.treePrinter.print(this.root);
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        this.addNode(testIdentifier, new TreeNode(testIdentifier));
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.getNode(testIdentifier).setResult(testExecutionResult);
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.addNode(testIdentifier, new TreeNode(testIdentifier, reason));
    }

    @Override
    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.getNode(testIdentifier).addReportEntry(entry);
    }

    @Override
    public void listTests(TestPlan testPlan) {
        this.root = new TreeNode(testPlan.toString());
        testPlan.accept(new TestPlan.Visitor(){

            @Override
            public void visit(TestIdentifier testIdentifier) {
                TreePrintingListener.this.addNode(testIdentifier, new TreeNode(testIdentifier));
            }
        });
        this.treePrinter.print(this.root);
    }
}

