/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;

@API(status=API.Status.STABLE, since="1.0")
public class MethodSelector
implements DiscoverySelector {
    private final ClassLoader classLoader;
    private final String className;
    private final String methodName;
    private final String methodParameterTypes;
    private Class<?> javaClass;
    private Method javaMethod;

    MethodSelector(String className, String methodName, ClassLoader classLoader) {
        this(className, methodName, "", classLoader);
    }

    MethodSelector(String className, String methodName, String methodParameterTypes, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.className = className;
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
    }

    MethodSelector(Class<?> javaClass, String methodName) {
        this(javaClass, methodName, "");
    }

    MethodSelector(Class<?> javaClass, String methodName, String methodParameterTypes) {
        this.classLoader = javaClass.getClassLoader();
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.methodName = methodName;
        this.methodParameterTypes = methodParameterTypes;
    }

    MethodSelector(Class<?> javaClass, Method method) {
        this.classLoader = javaClass.getClassLoader();
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.javaMethod = method;
        this.methodName = method.getName();
        this.methodParameterTypes = ClassUtils.nullSafeToString(method.getParameterTypes());
    }

    public String getClassName() {
        return this.className;
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.10")
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodParameterTypes() {
        return this.methodParameterTypes;
    }

    public Class<?> getJavaClass() {
        this.lazyLoadJavaClass();
        return this.javaClass;
    }

    public Method getJavaMethod() {
        this.lazyLoadJavaMethod();
        return this.javaMethod;
    }

    private void lazyLoadJavaClass() {
        if (this.javaClass == null) {
            Try<Class<?>> tryToLoadClass = this.classLoader == null ? ReflectionUtils.tryToLoadClass(this.className) : ReflectionUtils.tryToLoadClass(this.className, this.classLoader);
            this.javaClass = tryToLoadClass.getOrThrow(cause -> new PreconditionViolationException("Could not load class with name: " + this.className, (Throwable)cause));
        }
    }

    private void lazyLoadJavaMethod() {
        this.lazyLoadJavaClass();
        if (this.javaMethod == null) {
            this.javaMethod = StringUtils.isNotBlank(this.methodParameterTypes) ? ReflectionUtils.findMethod(this.javaClass, this.methodName, this.methodParameterTypes).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] and parameter types [%s] in class [%s].", this.methodName, this.methodParameterTypes, this.javaClass.getName()))) : ReflectionUtils.findMethod(this.javaClass, this.methodName, new Class[0]).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] in class [%s].", this.methodName, this.javaClass.getName())));
        }
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSelector that = (MethodSelector)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.methodParameterTypes, that.methodParameterTypes);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.methodParameterTypes);
    }

    public String toString() {
        return new ToStringBuilder(this).append("className", this.getClassName()).append("methodName", this.getMethodName()).append("methodParameterTypes", this.getMethodParameterTypes()).append("classLoader", this.getClassLoader()).toString();
    }
}

