/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.junit.platform.console.options.BaseCommand;
import org.junit.platform.console.options.CommandResult;
import org.junit.platform.console.options.DiscoverTestsCommand;
import org.junit.platform.console.options.ExecuteTestsCommand;
import org.junit.platform.console.options.ListTestEnginesCommand;
import org.junit.platform.console.shadow.picocli.CommandLine;
import org.junit.platform.console.tasks.ConsoleTestExecutor;

@CommandLine.Command(name="junit", abbreviateSynopsis=true, sortOptions=false, usageHelpWidth=95, showAtFileInUsageHelp=true, usageHelpAutoWidth=true, description={"Launches the JUnit Platform for test discovery and execution."}, footerHeading="%n", footer={"For more information, please refer to the JUnit User Guide at%n@|underline https://junit.org/junit5/docs/current/user-guide/|@"}, scope=CommandLine.ScopeType.INHERIT, exitCodeOnInvalidInput=-1, exitCodeOnExecutionException=-1)
class MainCommand
implements Callable<Object>,
CommandLine.IExitCodeGenerator {
    private final ConsoleTestExecutor.Factory consoleTestExecutorFactory;
    @CommandLine.Option(names={"-h", "--help"}, help=true, hidden=true)
    private boolean helpRequested;
    @CommandLine.Option(names={"--h", "-help"}, help=true, hidden=true)
    private boolean helpRequested2;
    @CommandLine.Unmatched
    private List<String> allParameters = new ArrayList<String>();
    @CommandLine.Spec
    CommandLine.Model.CommandSpec commandSpec;
    CommandResult<?> commandResult;

    MainCommand(ConsoleTestExecutor.Factory consoleTestExecutorFactory) {
        this.consoleTestExecutorFactory = consoleTestExecutorFactory;
    }

    @Override
    public Object call() {
        if (this.helpRequested || this.helpRequested2) {
            this.commandSpec.commandLine().usage(this.commandSpec.commandLine().getOut());
            this.commandResult = CommandResult.success();
            return null;
        }
        if (this.allParameters.contains("--list-engines")) {
            return this.runCommand("engines", Optional.of("--list-engines"));
        }
        return this.runCommand("execute", Optional.empty());
    }

    @Override
    public int getExitCode() {
        return this.commandResult.getExitCode();
    }

    private Object runCommand(String subcommand, Optional<String> triggeringOption) {
        CommandLine commandLine = this.commandSpec.commandLine();
        commandLine.setUnmatchedArgumentsAllowed(false);
        Object command = commandLine.getSubcommands().get(subcommand).getCommandSpec().userObject();
        ArrayList<String> args = new ArrayList<String>(commandLine.getParseResult().expandedArgs());
        triggeringOption.ifPresent(args::remove);
        CommandResult<?> result = MainCommand.runCommand(commandLine.getOut(), commandLine.getErr(), args.toArray(new String[0]), command);
        this.commandResult = result;
        MainCommand.printDeprecationWarning(subcommand, triggeringOption, commandLine);
        return result.getValue().orElse(null);
    }

    private static void printDeprecationWarning(String subcommand, Optional<String> triggeringOption, CommandLine commandLine) {
        PrintWriter err = commandLine.getErr();
        String reason = triggeringOption.map(it -> " due to use of '" + it + "'").orElse("");
        commandLine.getOut().flush();
        err.println();
        CommandLine.Help.ColorScheme colorScheme = commandLine.getColorScheme();
        err.println(colorScheme.string(String.format("@|yellow,bold WARNING:|@ Delegated to the '%s' command%s.", subcommand, reason)));
        err.println(colorScheme.string("         This behaviour has been deprecated and will be removed in a future release."));
        err.println(colorScheme.string("         Please use the '" + subcommand + "' command directly."));
        err.flush();
    }

    CommandResult<?> run(PrintWriter out, PrintWriter err, String[] args) {
        CommandLine commandLine = new CommandLine(this).addSubcommand(new DiscoverTestsCommand(this.consoleTestExecutorFactory)).addSubcommand(new ExecuteTestsCommand(this.consoleTestExecutorFactory)).addSubcommand(new ListTestEnginesCommand());
        return MainCommand.runCommand(out, err, args, commandLine);
    }

    private static CommandResult<?> runCommand(PrintWriter out, PrintWriter err, String[] args, Object command) {
        return MainCommand.runCommand(out, err, args, new CommandLine(command));
    }

    private static CommandResult<Object> runCommand(PrintWriter out, PrintWriter err, String[] args, CommandLine commandLine) {
        int exitCode = BaseCommand.initialize(commandLine).setOut(out).setErr(err).execute(args);
        return CommandResult.create(exitCode, commandLine.getExecutionResult());
    }
}

