/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.descriptor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.vintage.engine.descriptor.RunnerRequest;
import org.junit.vintage.engine.descriptor.VintageTestDescriptor;

@API(status=API.Status.INTERNAL, since="4.12")
public class RunnerTestDescriptor
extends VintageTestDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(RunnerTestDescriptor.class);
    private final Runner runner;
    private final Set<Description> rejectedExclusions = new HashSet<Description>();
    private boolean wasFiltered;

    public RunnerTestDescriptor(UniqueId uniqueId, Class<?> testClass, Runner runner) {
        super(uniqueId, runner.getDescription(), testClass.getName(), ClassSource.from(testClass));
        this.runner = runner;
    }

    public Request toRequest() {
        return new RunnerRequest(this.runner);
    }

    @Override
    protected boolean tryToExcludeFromRunner(Description description) {
        boolean excluded = this.tryToFilterRunner(description);
        if (excluded) {
            this.wasFiltered = true;
        } else {
            this.rejectedExclusions.add(description);
        }
        return excluded;
    }

    private boolean tryToFilterRunner(Description description) {
        if (this.runner instanceof Filterable) {
            ExcludeDescriptionFilter filter = new ExcludeDescriptionFilter(description);
            try {
                ((Filterable)((Object)this.runner)).filter(filter);
            }
            catch (NoTestsRemainException noTestsRemainException) {
                // empty catch block
            }
            return filter.wasSuccessful();
        }
        return false;
    }

    @Override
    protected boolean canBeRemovedFromHierarchy() {
        return true;
    }

    @Override
    public void prune() {
        if (this.wasFiltered) {
            this.pruneDescriptorsForObsoleteDescriptions(Collections.singletonList(this.runner.getDescription()));
        }
        if (this.rejectedExclusions.isEmpty()) {
            super.prune();
        } else if (this.rejectedExclusions.containsAll(this.getDescription().getChildren())) {
            this.removeFromHierarchy();
        } else {
            this.logIncompleteFiltering();
        }
    }

    private void logIncompleteFiltering() {
        if (this.runner instanceof Filterable) {
            logger.warn(() -> "Runner " + this.runner.getClass().getName() + " (used on " + this.getDescription().getTestClass() + ") was not able to satisfy all filter requests.");
        } else {
            logger.warn(() -> "Runner " + this.runner.getClass().getName() + " (used on " + this.getDescription().getTestClass() + ") does not support filtering and will therefore be run completely.");
        }
    }

    private static class ExcludeDescriptionFilter
    extends Filter {
        private final Description description;
        private boolean successful;

        ExcludeDescriptionFilter(Description description) {
            this.description = description;
        }

        @Override
        public boolean shouldRun(Description description) {
            if (this.description.equals(description)) {
                this.successful = true;
                return false;
            }
            return true;
        }

        @Override
        public String describe() {
            return "exclude " + this.description;
        }

        boolean wasSuccessful() {
            return this.successful;
        }
    }
}

