/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

abstract class MethodBasedTestDescriptor
extends JupiterTestDescriptor {
    private final Class<?> testClass;
    private final Method testMethod;
    private final Set<TestTag> tags;

    MethodBasedTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod) {
        this(uniqueId, MethodBasedTestDescriptor.determineDisplayName(Preconditions.notNull(testMethod, "Method must not be null"), MethodBasedTestDescriptor::generateDefaultDisplayName), testClass, testMethod);
    }

    MethodBasedTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Method testMethod) {
        super(uniqueId, displayName, MethodSource.from(Preconditions.notNull(testMethod, "Method must not be null")));
        this.testClass = Preconditions.notNull(testClass, "Class must not be null");
        this.testMethod = testMethod;
        this.tags = MethodBasedTestDescriptor.getTags(testMethod);
    }

    @Override
    public final Set<TestTag> getTags() {
        LinkedHashSet<TestTag> allTags = new LinkedHashSet<TestTag>(this.tags);
        this.getParent().ifPresent(parentDescriptor -> allTags.addAll(parentDescriptor.getTags()));
        return allTags;
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    public final Method getTestMethod() {
        return this.testMethod;
    }

    @Override
    public String getLegacyReportingName() {
        return MethodBasedTestDescriptor.generateDefaultDisplayName(this.testMethod);
    }

    private static String generateDefaultDisplayName(Method testMethod) {
        return String.format("%s(%s)", testMethod.getName(), ClassUtils.nullSafeToString(Class::getSimpleName, testMethod.getParameterTypes()));
    }
}

