/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.params.converter.ArgumentConverter;
import org.junit.jupiter.params.converter.ConvertWith;
import org.junit.jupiter.params.converter.DefaultArgumentConverter;
import org.junit.jupiter.params.support.AnnotationConsumerInitializer;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

class ParameterizedTestParameterResolver
implements ParameterResolver {
    private final Object[] arguments;

    ParameterizedTestParameterResolver(Object[] arguments) {
        this.arguments = arguments;
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Method testMethod;
        Executable declaringExecutable = parameterContext.getParameter().getDeclaringExecutable();
        return declaringExecutable.equals(testMethod = (Method)extensionContext.getTestMethod().orElse(null)) && parameterContext.getIndex() < this.arguments.length;
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Object argument = this.arguments[parameterContext.getIndex()];
        Parameter parameter = parameterContext.getParameter();
        Optional<ConvertWith> annotation = AnnotationUtils.findAnnotation(parameter, ConvertWith.class);
        ArgumentConverter argumentConverter = annotation.map(ConvertWith::value).map(clazz -> (ArgumentConverter)ReflectionUtils.newInstance(clazz, new Object[0])).map(converter -> AnnotationConsumerInitializer.initialize(parameter, converter)).orElse(DefaultArgumentConverter.INSTANCE);
        try {
            return argumentConverter.convert(argument, parameterContext);
        }
        catch (Exception ex) {
            throw new ParameterResolutionException("Error resolving parameter at index " + parameterContext.getIndex(), ex);
        }
    }
}

