/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.junit.jupiter.api.EnabledIf;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

class EnabledIfCondition
implements ExecutionCondition {
    private static final Logger logger = LoggerFactory.getLogger(EnabledIfCondition.class);
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@EnabledIf is not present");
    private static final Accessor systemPropertyAccessor = new SystemPropertyAccessor();
    private static final Accessor environmentVariableAccessor = new EnvironmentVariableAccessor();
    private static final String REASON_ANNOTATION_PLACEHOLDER = "{annotation}";
    private static final String REASON_SCRIPT_PLACEHOLDER = "{script}";
    private static final String REASON_RESULT_PLACEHOLDER = "{result}";

    EnabledIfCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional<EnabledIf> optionalAnnotation = AnnotationUtils.findAnnotation(context.getElement(), EnabledIf.class);
        if (!optionalAnnotation.isPresent()) {
            return ENABLED_BY_DEFAULT;
        }
        ConfigurationParameterAccessor configurationParameterAccessor = new ConfigurationParameterAccessor(context);
        Consumer<Bindings> contextBinder = bindings -> {
            bindings.put("junitTags", (Object)context.getTags());
            bindings.put("junitUniqueId", (Object)context.getUniqueId());
            bindings.put("junitDisplayName", (Object)context.getDisplayName());
            bindings.put("junitConfigurationParameter", (Object)configurationParameterAccessor);
        };
        return this.evaluate(optionalAnnotation.get(), contextBinder);
    }

    ConditionEvaluationResult evaluate(EnabledIf annotation, Consumer<Bindings> binder) {
        Preconditions.notNull(annotation, "annotation must not be null");
        Preconditions.notNull(binder, "binder must not be null");
        Preconditions.notEmpty(annotation.value(), "String[] returned by @EnabledIf.value() must not be empty");
        ScriptEngine scriptEngine = this.findScriptEngine(annotation.engine());
        logger.debug(() -> "ScriptEngine: " + scriptEngine);
        Bindings bindings = scriptEngine.getBindings(100);
        bindings.put("systemProperty", (Object)systemPropertyAccessor);
        bindings.put("systemEnvironment", (Object)environmentVariableAccessor);
        binder.accept(bindings);
        logger.debug(() -> "Bindings: " + bindings);
        String script = this.createScript(annotation, scriptEngine.getFactory().getLanguageName());
        logger.debug(() -> "Script: " + script);
        return this.evaluate(annotation, scriptEngine, script);
    }

    private ConditionEvaluationResult evaluate(EnabledIf annotation, ScriptEngine scriptEngine, String script) {
        Object result;
        try {
            result = scriptEngine.eval(script);
        }
        catch (ScriptException e) {
            String caption = "Evaluation of @EnabledIf script failed.";
            String bindings = scriptEngine.getBindings(100).entrySet().toString();
            String message = String.format("%s script=`%s`, bindings=%s", caption, script, bindings);
            throw new JUnitException(message, e);
        }
        if (result instanceof ConditionEvaluationResult) {
            return (ConditionEvaluationResult)result;
        }
        String resultAsString = String.valueOf(result);
        String reason = this.createReason(annotation, script, resultAsString);
        boolean enabled = result instanceof Boolean ? (Boolean)result : Boolean.parseBoolean(resultAsString);
        return enabled ? ConditionEvaluationResult.enabled(reason) : ConditionEvaluationResult.disabled(reason);
    }

    ScriptEngine findScriptEngine(String engine) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine scriptEngine = manager.getEngineByName(engine);
        if (scriptEngine == null) {
            scriptEngine = manager.getEngineByExtension(engine);
        }
        if (scriptEngine == null) {
            scriptEngine = manager.getEngineByMimeType(engine);
        }
        Preconditions.notNull(scriptEngine, () -> "Script engine not found: " + engine);
        return scriptEngine;
    }

    String createScript(EnabledIf annotation, String language) {
        String[] lines = annotation.value();
        if (lines.length == 1) {
            return lines[0];
        }
        return this.joinLines(System.lineSeparator(), Arrays.asList(lines));
    }

    String createReason(EnabledIf annotation, String script, String result) {
        String reason = annotation.reason();
        reason = reason.replace(REASON_ANNOTATION_PLACEHOLDER, annotation.toString());
        reason = reason.replace(REASON_SCRIPT_PLACEHOLDER, script);
        reason = reason.replace(REASON_RESULT_PLACEHOLDER, result);
        return reason;
    }

    private String joinLines(String delimiter, Iterable<? extends CharSequence> elements) {
        if (StringUtils.isBlank(delimiter)) {
            delimiter = System.lineSeparator();
        }
        return String.join((CharSequence)delimiter, elements);
    }

    private static class ConfigurationParameterAccessor
    implements Accessor {
        private final ExtensionContext context;

        ConfigurationParameterAccessor(ExtensionContext context) {
            this.context = context;
        }

        @Override
        public String get(String key) {
            return this.context.getConfigurationParameter(key).orElse(null);
        }
    }

    private static class EnvironmentVariableAccessor
    implements Accessor {
        private EnvironmentVariableAccessor() {
        }

        @Override
        public String get(String name) {
            return System.getenv(name);
        }
    }

    private static class SystemPropertyAccessor
    implements Accessor {
        private SystemPropertyAccessor() {
        }

        @Override
        public String get(String name) {
            return System.getProperty(name);
        }
    }

    public static interface Accessor {
        public String get(String var1);
    }
}

