/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.Details;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.CustomContextClassLoaderExecutor;
import org.junit.platform.console.tasks.DiscoveryRequestCreator;
import org.junit.platform.console.tasks.FlatPrintingListener;
import org.junit.platform.console.tasks.TreePrintingListener;
import org.junit.platform.console.tasks.VerboseTreePrintingListener;
import org.junit.platform.console.tasks.XmlReportsWritingListener;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@API(status=API.Status.INTERNAL, since="1.0")
public class ConsoleTestExecutor {
    private final CommandLineOptions options;
    private final Supplier<Launcher> launcherSupplier;

    public ConsoleTestExecutor(CommandLineOptions options) {
        this(options, LauncherFactory::create);
    }

    ConsoleTestExecutor(CommandLineOptions options, Supplier<Launcher> launcherSupplier) {
        this.options = options;
        this.launcherSupplier = launcherSupplier;
    }

    public TestExecutionSummary execute(PrintWriter out) throws Exception {
        return new CustomContextClassLoaderExecutor(this.createCustomClassLoader()).invoke(() -> this.executeTests(out));
    }

    private TestExecutionSummary executeTests(PrintWriter out) {
        Launcher launcher = this.launcherSupplier.get();
        SummaryGeneratingListener summaryListener = this.registerListeners(out, launcher);
        LauncherDiscoveryRequest discoveryRequest = new DiscoveryRequestCreator().toDiscoveryRequest(this.options);
        launcher.execute(discoveryRequest, new TestExecutionListener[0]);
        TestExecutionSummary summary = summaryListener.getSummary();
        this.printSummary(summary, out);
        return summary;
    }

    private Optional<ClassLoader> createCustomClassLoader() {
        List<Path> additionalClasspathEntries = this.options.getAdditionalClasspathEntries();
        if (!additionalClasspathEntries.isEmpty()) {
            URL[] urls = (URL[])additionalClasspathEntries.stream().map(this::toURL).toArray(URL[]::new);
            ClassLoader parentClassLoader = ClassLoaderUtils.getDefaultClassLoader();
            URLClassLoader customClassLoader = URLClassLoader.newInstance(urls, parentClassLoader);
            return Optional.of(customClassLoader);
        }
        return Optional.empty();
    }

    private URL toURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (Exception ex) {
            throw new JUnitException("Invalid classpath entry: " + path, ex);
        }
    }

    private SummaryGeneratingListener registerListeners(PrintWriter out, Launcher launcher) {
        SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners(summaryListener);
        this.createDetailsPrintingListener(out).ifPresent(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
        this.createXmlWritingListener(out).ifPresent(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
        return summaryListener;
    }

    private Optional<TestExecutionListener> createDetailsPrintingListener(PrintWriter out) {
        boolean disableAnsiColors = this.options.isAnsiColorOutputDisabled();
        Theme theme = this.options.getTheme();
        switch (this.options.getDetails()) {
            case FLAT: {
                return Optional.of(new FlatPrintingListener(out, disableAnsiColors));
            }
            case TREE: {
                return Optional.of(new TreePrintingListener(out, disableAnsiColors, theme));
            }
            case VERBOSE: {
                return Optional.of(new VerboseTreePrintingListener(out, disableAnsiColors, 16, theme));
            }
        }
        return Optional.empty();
    }

    private Optional<TestExecutionListener> createXmlWritingListener(PrintWriter out) {
        return this.options.getReportsDir().map(reportsDir -> new XmlReportsWritingListener((Path)reportsDir, out));
    }

    private void printSummary(TestExecutionSummary summary, PrintWriter out) {
        if (EnumSet.of(Details.NONE, Details.TREE).contains((Object)this.options.getDetails())) {
            summary.printFailuresTo(out);
        }
        summary.printTo(out);
    }
}

