/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common.processor.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.Context;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.processor.core.AbstractMultiBeanRowProcessor;

public class AbstractMultiBeanListProcessor<C extends Context>
extends AbstractMultiBeanRowProcessor<C> {
    private final Class[] beanTypes;
    private final List[] beans;
    private String[] headers;

    public AbstractMultiBeanListProcessor(Class ... beanTypes) {
        super(beanTypes);
        this.beanTypes = beanTypes;
        this.beans = new List[beanTypes.length];
        for (int i2 = 0; i2 < beanTypes.length; ++i2) {
            this.beans[i2] = new ArrayList(1000);
        }
    }

    @Override
    public final void processStarted(C context) {
        super.processStarted(context);
        for (int i2 = 0; i2 < this.beanTypes.length; ++i2) {
            this.beans[i2] = new ArrayList(1000);
        }
    }

    @Override
    protected final void rowProcessed(Map<Class<?>, Object> row, C context) {
        for (int i2 = 0; i2 < this.beanTypes.length; ++i2) {
            Object bean = row.get(this.beanTypes[i2]);
            this.beans[i2].add(bean);
        }
    }

    @Override
    public final void processEnded(C context) {
        this.headers = context.headers();
        super.processEnded(context);
    }

    public final String[] getHeaders() {
        return this.headers;
    }

    public <T> List<T> getBeans(Class<T> beanType) {
        int index = ArgumentUtils.indexOf(this.beanTypes, beanType);
        if (index == -1) {
            throw new IllegalArgumentException("Unknown bean type '" + beanType.getSimpleName() + "'. Available types are: " + Arrays.toString(this.beanTypes));
        }
        return this.beans[index];
    }

    public Map<Class<?>, List<?>> getBeans() {
        LinkedHashMap out = new LinkedHashMap();
        for (int i2 = 0; i2 < this.beanTypes.length; ++i2) {
            out.put(this.beanTypes[i2], this.beans[i2]);
        }
        return out;
    }
}

