/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.extension;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.STABLE, since="5.0")
public interface ExtensionContext {
    public Optional<ExtensionContext> getParent();

    public ExtensionContext getRoot();

    public String getUniqueId();

    public String getDisplayName();

    public Set<String> getTags();

    public Optional<AnnotatedElement> getElement();

    public Optional<Class<?>> getTestClass();

    default public Class<?> getRequiredTestClass() {
        return Preconditions.notNull(this.getTestClass().orElse(null), "Illegal state: required test class is not present in the current ExtensionContext");
    }

    public Optional<Object> getTestInstance();

    default public Object getRequiredTestInstance() {
        return Preconditions.notNull(this.getTestInstance().orElse(null), "Illegal state: required test instance is not present in the current ExtensionContext");
    }

    public Optional<Method> getTestMethod();

    default public Method getRequiredTestMethod() {
        return Preconditions.notNull(this.getTestMethod().orElse(null), "Illegal state: required test method is not present in the current ExtensionContext");
    }

    public Optional<Throwable> getExecutionException();

    public void publishReportEntry(Map<String, String> var1);

    default public void publishReportEntry(String key, String value) {
        this.publishReportEntry(Collections.singletonMap(key, value));
    }

    public Store getStore(Namespace var1);

    public static class Namespace {
        public static final Namespace GLOBAL = Namespace.create(new Object());
        private final List<?> parts;

        public static Namespace create(Object ... parts) {
            Preconditions.notEmpty(parts, "parts array must not be null or empty");
            Preconditions.containsNoNullElements(parts, "individual parts must not be null");
            return new Namespace(parts);
        }

        private Namespace(Object ... parts) {
            this.parts = new ArrayList<Object>(Arrays.asList(parts));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Namespace that = (Namespace)o;
            return this.parts.equals(that.parts);
        }

        public int hashCode() {
            return this.parts.hashCode();
        }
    }

    public static interface Store {
        public Object get(Object var1);

        public <V> V get(Object var1, Class<V> var2);

        public <K, V> Object getOrComputeIfAbsent(K var1, Function<K, V> var2);

        public <K, V> V getOrComputeIfAbsent(K var1, Function<K, V> var2, Class<V> var3);

        public void put(Object var1, Object var2);

        public Object remove(Object var1);

        public <V> V remove(Object var1, Class<V> var2);
    }
}

