/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.time.Duration;
import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.junit.platform.commons.util.ExceptionUtils;

class AssertTimeout {
    private AssertTimeout() {
    }

    static void assertTimeout(Duration timeout, Executable executable) {
        AssertTimeout.assertTimeout(timeout, executable, () -> null);
    }

    static void assertTimeout(Duration timeout, Executable executable, String message) {
        AssertTimeout.assertTimeout(timeout, executable, () -> message);
    }

    static void assertTimeout(Duration timeout, Executable executable, Supplier<String> messageSupplier) {
        AssertTimeout.assertTimeout(timeout, () -> {
            executable.execute();
            return null;
        }, messageSupplier);
    }

    static <T> T assertTimeout(Duration timeout, ThrowingSupplier<T> supplier) {
        return AssertTimeout.assertTimeout(timeout, supplier, () -> null);
    }

    static <T> T assertTimeout(Duration timeout, ThrowingSupplier<T> supplier, String message) {
        return AssertTimeout.assertTimeout(timeout, supplier, () -> message);
    }

    static <T> T assertTimeout(Duration timeout, ThrowingSupplier<T> supplier, Supplier<String> messageSupplier) {
        long timeoutInMillis = timeout.toMillis();
        long start = System.currentTimeMillis();
        T result = null;
        try {
            result = supplier.get();
        }
        catch (Throwable ex) {
            ExceptionUtils.throwAsUncheckedException(ex);
        }
        long timeElapsed = System.currentTimeMillis() - start;
        if (timeElapsed > timeoutInMillis) {
            Assertions.fail(AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier)) + "execution exceeded timeout of " + timeoutInMillis + " ms by " + (timeElapsed - timeoutInMillis) + " ms");
        }
        return result;
    }

    static void assertTimeoutPreemptively(Duration timeout, Executable executable) {
        AssertTimeout.assertTimeoutPreemptively(timeout, executable, () -> null);
    }

    static void assertTimeoutPreemptively(Duration timeout, Executable executable, String message) {
        AssertTimeout.assertTimeoutPreemptively(timeout, executable, () -> message);
    }

    static void assertTimeoutPreemptively(Duration timeout, Executable executable, Supplier<String> messageSupplier) {
        AssertTimeout.assertTimeoutPreemptively(timeout, () -> {
            executable.execute();
            return null;
        }, messageSupplier);
    }

    static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier) {
        return AssertTimeout.assertTimeoutPreemptively(timeout, supplier, () -> null);
    }

    static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier, String message) {
        return AssertTimeout.assertTimeoutPreemptively(timeout, supplier, () -> message);
    }

    /*
     * Exception decompiling
     */
    static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier, Supplier<String> messageSupplier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Object lambda$assertTimeoutPreemptively$10(ThrowingSupplier supplier) throws Exception {
        try {
            return supplier.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtils.throwAsUncheckedException(throwable);
        }
    }
}

