/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.filter.ClasspathScanningSupport;
import org.junit.platform.engine.support.filter.ExclusionReasonConsumingFilter;
import org.junit.vintage.engine.discovery.ClassSelectorResolver;
import org.junit.vintage.engine.discovery.ClasspathRootSelectorResolver;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.IsPotentialJUnit4TestClass;
import org.junit.vintage.engine.discovery.MethodSelectorResolver;
import org.junit.vintage.engine.discovery.PackageNameSelectorResolver;
import org.junit.vintage.engine.discovery.TestClassCollector;
import org.junit.vintage.engine.discovery.TestClassRequest;
import org.junit.vintage.engine.discovery.TestClassRequestResolver;
import org.junit.vintage.engine.discovery.UniqueIdSelectorResolver;

@API(status=API.Status.INTERNAL, since="4.12")
public class VintageDiscoverer {
    private static final IsPotentialJUnit4TestClass isPotentialJUnit4TestClass = new IsPotentialJUnit4TestClass();
    private final Logger logger;
    private final TestClassRequestResolver resolver;

    public VintageDiscoverer(Logger logger) {
        this.logger = logger;
        this.resolver = new TestClassRequestResolver(logger);
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        EngineDescriptor engineDescriptor = new EngineDescriptor(uniqueId, "JUnit Vintage");
        this.collectTestClasses(discoveryRequest).toRequests().map(request -> this.resolver.createRunnerTestDescriptor((TestClassRequest)request, uniqueId)).filter(Objects::nonNull).forEach(engineDescriptor::addChild);
        return engineDescriptor;
    }

    private TestClassCollector collectTestClasses(EngineDiscoveryRequest discoveryRequest) {
        Predicate<Class<?>> classFilter = this.createTestClassPredicate(discoveryRequest);
        TestClassCollector collector = new TestClassCollector();
        for (DiscoverySelectorResolver selectorResolver : this.getAllDiscoverySelectorResolvers(discoveryRequest)) {
            selectorResolver.resolve(discoveryRequest, classFilter, collector);
        }
        return collector;
    }

    private List<DiscoverySelectorResolver> getAllDiscoverySelectorResolvers(EngineDiscoveryRequest request) {
        Predicate<String> classNamePredicate = ClasspathScanningSupport.buildClassNamePredicate(request);
        return Arrays.asList(new ClasspathRootSelectorResolver(classNamePredicate), new PackageNameSelectorResolver(classNamePredicate), new ClassSelectorResolver(), new MethodSelectorResolver(), new UniqueIdSelectorResolver(this.logger));
    }

    private Predicate<Class<?>> createTestClassPredicate(EngineDiscoveryRequest discoveryRequest) {
        List<ClassNameFilter> allClassNameFilters = discoveryRequest.getFiltersByType(ClassNameFilter.class);
        Filter<Class> adaptedFilter = Filter.adaptFilter(Filter.composeFilters(allClassNameFilters), Class::getName);
        ExclusionReasonConsumingFilter<Class> classFilter = new ExclusionReasonConsumingFilter<Class>(adaptedFilter, (testClass, reason) -> this.logger.debug(() -> String.format("Class %s was excluded by a class filter: %s", testClass.getName(), reason.orElse("<unknown reason>"))));
        return classFilter.toPredicate().and(isPotentialJUnit4TestClass);
    }
}

