/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.ParameterizedTestInvocationContext;
import org.junit.jupiter.params.ParameterizedTestNameFormatter;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.junit.jupiter.params.support.AnnotationConsumerInitializer;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

class ParameterizedTestExtension
implements TestTemplateInvocationContextProvider {
    ParameterizedTestExtension() {
    }

    @Override
    public boolean supportsTestTemplate(ExtensionContext context) {
        return AnnotationUtils.isAnnotated(context.getTestMethod(), ParameterizedTest.class);
    }

    @Override
    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        Method templateMethod = context.getRequiredTestMethod();
        ParameterizedTestNameFormatter formatter = this.createNameFormatter(templateMethod);
        AtomicLong invocationCount = new AtomicLong(0L);
        return (Stream)AnnotationUtils.findRepeatableAnnotations(templateMethod, ArgumentsSource.class).stream().map(ArgumentsSource::value).map(x$0 -> (ArgumentsProvider)ReflectionUtils.newInstance(x$0, new Object[0])).map(provider -> AnnotationConsumerInitializer.initialize(templateMethod, provider)).flatMap(provider -> ParameterizedTestExtension.arguments(provider, context)).map(Arguments::get).map(arguments -> this.createInvocationContext(formatter, (Object[])arguments)).peek(invocationContext -> invocationCount.incrementAndGet()).onClose(() -> Preconditions.condition(invocationCount.get() > 0L, () -> "Configuration error: You must provide at least one argument for this @" + ParameterizedTest.class.getSimpleName()));
    }

    private TestTemplateInvocationContext createInvocationContext(ParameterizedTestNameFormatter formatter, Object[] arguments) {
        return new ParameterizedTestInvocationContext(formatter, arguments);
    }

    private ParameterizedTestNameFormatter createNameFormatter(Method templateMethod) {
        ParameterizedTest parameterizedTest = AnnotationUtils.findAnnotation(templateMethod, ParameterizedTest.class).get();
        String name = Preconditions.notBlank(parameterizedTest.name().trim(), () -> String.format("Configuration error: @ParameterizedTest on method [%s] must be declared with a non-empty name.", templateMethod));
        return new ParameterizedTestNameFormatter(name);
    }

    protected static Stream<? extends Arguments> arguments(ArgumentsProvider provider, ExtensionContext context) {
        try {
            return provider.provideArguments(context);
        }
        catch (Exception e) {
            throw ExceptionUtils.throwAsUncheckedException(e);
        }
    }
}

