/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.engine.descriptor.ClassExtensionContext;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.LifecycleMethodUtils;
import org.junit.jupiter.engine.descriptor.TestInstanceLifecycleUtils;
import org.junit.jupiter.engine.execution.AfterEachMethodAdapter;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.execution.TestInstanceProvider;
import org.junit.jupiter.engine.execution.ThrowableCollector;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

@API(status=API.Status.INTERNAL, since="5.0")
public class ClassTestDescriptor
extends JupiterTestDescriptor {
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();
    private final Class<?> testClass;
    private List<Method> beforeAllMethods;
    private List<Method> afterAllMethods;
    private List<Method> beforeEachMethods;
    private List<Method> afterEachMethods;

    public ClassTestDescriptor(UniqueId uniqueId, Class<?> testClass) {
        this(uniqueId, ClassTestDescriptor::generateDefaultDisplayName, testClass);
    }

    protected ClassTestDescriptor(UniqueId uniqueId, Function<Class<?>, String> defaultDisplayNameGenerator, Class<?> testClass) {
        super(uniqueId, ClassTestDescriptor.determineDisplayName((AnnotatedElement)Preconditions.notNull(testClass, "Class must not be null"), defaultDisplayNameGenerator), ClassSource.from(testClass));
        this.testClass = testClass;
    }

    @Override
    public Set<TestTag> getTags() {
        return ClassTestDescriptor.getTags(this.testClass);
    }

    public final Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public String getLegacyReportingName() {
        return this.testClass.getName();
    }

    private static String generateDefaultDisplayName(Class<?> testClass) {
        String name = testClass.getName();
        int index = name.lastIndexOf(46);
        return name.substring(index + 1);
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) {
        TestInstance.Lifecycle lifecycle = TestInstanceLifecycleUtils.getTestInstanceLifecycle(this.testClass, context.getConfigurationParameters());
        this.beforeAllMethods = LifecycleMethodUtils.findBeforeAllMethods(this.testClass, lifecycle == TestInstance.Lifecycle.PER_METHOD);
        this.afterAllMethods = LifecycleMethodUtils.findAfterAllMethods(this.testClass, lifecycle == TestInstance.Lifecycle.PER_METHOD);
        this.beforeEachMethods = LifecycleMethodUtils.findBeforeEachMethods(this.testClass);
        this.afterEachMethods = LifecycleMethodUtils.findAfterEachMethods(this.testClass);
        ExtensionRegistry registry = this.populateNewExtensionRegistryFromExtendWith(this.testClass, context.getExtensionRegistry());
        this.registerBeforeEachMethodAdapters(registry);
        this.registerAfterEachMethodAdapters(registry);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        ClassExtensionContext extensionContext = new ClassExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, throwableCollector);
        return context.extend().withTestInstanceProvider(this.testInstanceProvider(context, registry, extensionContext, lifecycle)).withExtensionRegistry(registry).withExtensionContext(extensionContext).withThrowableCollector(throwableCollector).build();
    }

    @Override
    public JupiterEngineExecutionContext before(JupiterEngineExecutionContext context) throws Exception {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        this.invokeBeforeAllCallbacks(context);
        if (throwableCollector.isEmpty()) {
            context.beforeAllMethodsExecuted(true);
            this.invokeBeforeAllMethods(context);
        }
        throwableCollector.assertEmpty();
        return context;
    }

    @Override
    public void after(JupiterEngineExecutionContext context) throws Exception {
        if (context.beforeAllMethodsExecuted()) {
            this.invokeAfterAllMethods(context);
        }
        this.invokeAfterAllCallbacks(context);
        context.getThrowableCollector().assertEmpty();
    }

    private TestInstanceProvider testInstanceProvider(JupiterEngineExecutionContext parentExecutionContext, ExtensionRegistry registry, ClassExtensionContext extensionContext, TestInstance.Lifecycle lifecycle) {
        if (lifecycle == TestInstance.Lifecycle.PER_CLASS) {
            Object instance = this.instantiateAndPostProcessTestInstance(parentExecutionContext, extensionContext, registry);
            extensionContext.setTestInstance(instance);
            return childRegistry -> instance;
        }
        return childRegistry -> this.instantiateAndPostProcessTestInstance(parentExecutionContext, extensionContext, childRegistry.orElse(registry));
    }

    private Object instantiateAndPostProcessTestInstance(JupiterEngineExecutionContext context, ExtensionContext extensionContext, ExtensionRegistry registry) {
        Object instance = this.instantiateTestClass(context, registry, extensionContext);
        this.invokeTestInstancePostProcessors(instance, registry, extensionContext);
        return instance;
    }

    protected Object instantiateTestClass(JupiterEngineExecutionContext parentExecutionContext, ExtensionRegistry registry, ExtensionContext extensionContext) {
        Constructor<?> constructor = ReflectionUtils.getDeclaredConstructor(this.testClass);
        return executableInvoker.invoke(constructor, extensionContext, registry);
    }

    private void invokeTestInstancePostProcessors(Object instance, ExtensionRegistry registry, ExtensionContext context) {
        registry.stream(TestInstancePostProcessor.class).forEach(extension -> this.executeAndMaskThrowable(() -> extension.postProcessTestInstance(instance, context)));
    }

    private void invokeBeforeAllCallbacks(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        for (BeforeAllCallback callback : registry.getExtensions(BeforeAllCallback.class)) {
            throwableCollector.execute(() -> callback.beforeAll(extensionContext));
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    private void invokeBeforeAllMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        for (Method method : this.beforeAllMethods) {
            throwableCollector.execute(() -> executableInvoker.invoke(method, testInstance, extensionContext, registry));
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    private void invokeAfterAllMethods(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Object testInstance = extensionContext.getTestInstance().orElse(null);
        this.afterAllMethods.forEach(method -> throwableCollector.execute(() -> executableInvoker.invoke((Method)method, (Object)testInstance, extensionContext, registry)));
    }

    private void invokeAfterAllCallbacks(JupiterEngineExecutionContext context) {
        ExtensionRegistry registry = context.getExtensionRegistry();
        ExtensionContext extensionContext = context.getExtensionContext();
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        registry.getReversedExtensions(AfterAllCallback.class).forEach(extension -> throwableCollector.execute(() -> extension.afterAll(extensionContext)));
    }

    private void registerBeforeEachMethodAdapters(ExtensionRegistry registry) {
        this.registerMethodsAsExtensions(this.beforeEachMethods, registry, this::synthesizeBeforeEachMethodAdapter);
    }

    private void registerAfterEachMethodAdapters(ExtensionRegistry registry) {
        ArrayList<Method> reversed = new ArrayList<Method>(this.afterEachMethods);
        Collections.reverse(reversed);
        this.registerMethodsAsExtensions(reversed, registry, this::synthesizeAfterEachMethodAdapter);
    }

    private void registerMethodsAsExtensions(List<Method> methods, ExtensionRegistry registry, Function<Method, Extension> extensionSynthesizer) {
        methods.forEach(method -> registry.registerExtension((Extension)extensionSynthesizer.apply((Method)method), method));
    }

    private BeforeEachMethodAdapter synthesizeBeforeEachMethodAdapter(Method method) {
        return (extensionContext, registry) -> this.invokeMethodInExtensionContext(method, extensionContext, registry);
    }

    private AfterEachMethodAdapter synthesizeAfterEachMethodAdapter(Method method) {
        return (extensionContext, registry) -> this.invokeMethodInExtensionContext(method, extensionContext, registry);
    }

    private void invokeMethodInExtensionContext(Method method, ExtensionContext context, ExtensionRegistry registry) {
        Object testInstance = context.getRequiredTestInstance();
        testInstance = ReflectionUtils.getOutermostInstance(testInstance, method.getDeclaringClass()).orElseThrow(() -> new JUnitException("Failed to find instance for method: " + method.toGenericString()));
        executableInvoker.invoke(method, testInstance, context, registry);
    }
}

