/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.Assertions;

class AssertNotNull {
    private AssertNotNull() {
    }

    static void assertNotNull(Object actual) {
        AssertNotNull.assertNotNull(actual, () -> null);
    }

    static void assertNotNull(Object actual, String message) {
        AssertNotNull.assertNotNull(actual, () -> message);
    }

    static void assertNotNull(Object actual, Supplier<String> messageSupplier) {
        if (actual == null) {
            AssertNotNull.failNull(AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    private static void failNull(String message) {
        Assertions.fail(AssertionUtils.buildPrefix(message) + "expected: not <null>");
    }
}

