/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.descriptor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.experimental.categories.Category;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.runner.Description;

@API(value=API.Usage.Internal)
public class VintageTestDescriptor
extends AbstractTestDescriptor {
    public static final String ENGINE_ID = "junit-vintage";
    public static final String SEGMENT_TYPE_RUNNER = "runner";
    public static final String SEGMENT_TYPE_TEST = "test";
    public static final String SEGMENT_TYPE_DYNAMIC = "dynamic";
    private final Description description;

    public VintageTestDescriptor(UniqueId uniqueId, Description description) {
        this(uniqueId, description, VintageTestDescriptor.generateDisplayName(description), VintageTestDescriptor.toTestSource(description));
    }

    VintageTestDescriptor(UniqueId uniqueId, Description description, String displayName, TestSource source) {
        super(uniqueId, displayName, source);
        this.description = description;
    }

    private static String generateDisplayName(Description description) {
        return description.getMethodName() != null ? description.getMethodName() : description.getDisplayName();
    }

    public Description getDescription() {
        return this.description;
    }

    @Override
    public TestDescriptor.Type getType() {
        return this.description.isTest() ? TestDescriptor.Type.TEST : TestDescriptor.Type.CONTAINER;
    }

    @Override
    public Set<TestTag> getTags() {
        LinkedHashSet<TestTag> tags = new LinkedHashSet<TestTag>();
        this.addTagsFromParent(tags);
        this.addCategoriesAsTags(tags);
        return tags;
    }

    private void addTagsFromParent(Set<TestTag> tags) {
        this.getParent().map(TestDescriptor::getTags).ifPresent(tags::addAll);
    }

    private void addCategoriesAsTags(Set<TestTag> tags) {
        Category annotation = this.description.getAnnotation(Category.class);
        if (annotation != null) {
            Arrays.stream(annotation.value()).map(ReflectionUtils::getAllAssignmentCompatibleClasses).flatMap(Collection::stream).distinct().map(Class::getName).map(TestTag::create).forEachOrdered(tags::add);
        }
    }

    private static TestSource toTestSource(Description description) {
        Class<?> testClass = description.getTestClass();
        if (testClass != null) {
            MethodSource methodSource;
            String methodName = description.getMethodName();
            if (methodName != null && (methodSource = VintageTestDescriptor.toMethodSource(testClass, methodName)) != null) {
                return methodSource;
            }
            return new ClassSource(testClass);
        }
        return null;
    }

    private static MethodSource toMethodSource(Class<?> testClass, String methodName) {
        if (methodName.contains("[") && methodName.endsWith("]")) {
            return VintageTestDescriptor.toMethodSource(testClass, methodName.substring(0, methodName.indexOf("[")));
        }
        List<Method> methods = ReflectionUtils.findMethods(testClass, FunctionUtils.where(Method::getName, Predicate.isEqual(methodName)));
        return methods.size() == 1 ? new MethodSource(CollectionUtils.getOnlyElement(methods)) : null;
    }
}

