/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.ConfigurationParameters;

class LauncherConfigurationParameters
implements ConfigurationParameters {
    private static final Logger logger = Logger.getLogger(LauncherConfigurationParameters.class.getName());
    private final Map<String, String> explicitConfigParams;
    private final Properties configParamsFromFile;

    LauncherConfigurationParameters(Map<String, String> configParams) {
        this(configParams, "junit-platform.properties");
    }

    LauncherConfigurationParameters(Map<String, String> configParams, String configFileName) {
        Preconditions.notNull(configParams, "configuration parameters must not be null");
        Preconditions.notBlank(configFileName, "configFileName must not be null or blank");
        this.explicitConfigParams = configParams;
        this.configParamsFromFile = LauncherConfigurationParameters.fromClasspathResource(configFileName.trim());
    }

    private static Properties fromClasspathResource(String configFileName) {
        Properties props;
        block15: {
            props = new Properties();
            try {
                ClassLoader classLoader = ClassLoaderUtils.getDefaultClassLoader();
                ArrayList<URL> resources = Collections.list(classLoader.getResources(configFileName));
                if (resources.isEmpty()) break block15;
                if (resources.size() > 1) {
                    logger.warning(() -> String.format("Discovered %d '%s' configuration files in the classpath; only the first will be used.", resources.size(), configFileName));
                }
                URL configFileUrl = (URL)resources.get(0);
                logger.info(() -> String.format("Loading JUnit Platform configuration parameters from classpath resource [%s].", configFileUrl));
                try (InputStream inputStream = configFileUrl.openStream();){
                    props.load(inputStream);
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex, () -> String.format("Failed to load JUnit Platform configuration parameters from classpath resource [%s].", configFileName));
            }
        }
        return props;
    }

    @Override
    public Optional<String> get(String key) {
        return Optional.ofNullable(this.getProperty(key));
    }

    @Override
    public Optional<Boolean> getBoolean(String key) {
        String property = this.getProperty(key);
        if (property != null) {
            return Optional.of(Boolean.parseBoolean(property));
        }
        return Optional.empty();
    }

    @Override
    public int size() {
        return this.explicitConfigParams.size();
    }

    private String getProperty(String key) {
        Preconditions.notBlank(key, "key must not be null or blank");
        String value = this.explicitConfigParams.get(key);
        if (value == null) {
            try {
                value = System.getProperty(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == null) {
                value = this.configParamsFromFile.getProperty(key);
            }
        }
        return value;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        this.explicitConfigParams.forEach(builder::append);
        this.configParamsFromFile.stringPropertyNames().stream().filter(key -> !this.explicitConfigParams.containsKey(key)).forEach(key -> builder.append((String)key, this.configParamsFromFile.getProperty((String)key)));
        return builder.toString();
    }
}

