/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.HashSet;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.BlacklistedExceptions;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.ExecutionListenerAdapter;
import org.junit.platform.launcher.core.Root;
import org.junit.platform.launcher.core.TestExecutionListenerRegistry;

class DefaultLauncher
implements Launcher {
    private static final Logger logger = Logger.getLogger(DefaultLauncher.class.getName());
    private final TestExecutionListenerRegistry listenerRegistry = new TestExecutionListenerRegistry();
    private final Iterable<TestEngine> testEngines;

    DefaultLauncher(Iterable<TestEngine> testEngines) {
        Preconditions.condition(testEngines != null && testEngines.iterator().hasNext(), () -> "Cannot create Launcher without at least one TestEngine; consider adding an engine implementation JAR to the classpath");
        this.testEngines = DefaultLauncher.validateUniqueIds(testEngines);
    }

    private static Iterable<TestEngine> validateUniqueIds(Iterable<TestEngine> testEngines) {
        HashSet<String> ids = new HashSet<String>();
        for (TestEngine testEngine : testEngines) {
            if (ids.add(testEngine.getId())) continue;
            throw new JUnitException(String.format("Cannot create Launcher for multiple engines with the same ID '%s'.", testEngine.getId()));
        }
        return testEngines;
    }

    @Override
    public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
        Preconditions.notEmpty(listeners, "listeners array must not be null or empty");
        Preconditions.containsNoNullElements(listeners, "individual listeners must not be null");
        this.listenerRegistry.registerListeners(listeners);
    }

    @Override
    public TestPlan discover(LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notNull(discoveryRequest, "LauncherDiscoveryRequest must not be null");
        return TestPlan.from(this.discoverRoot(discoveryRequest, "discovery").getEngineDescriptors());
    }

    @Override
    public void execute(LauncherDiscoveryRequest discoveryRequest, TestExecutionListener ... listeners) {
        Preconditions.notNull(discoveryRequest, "LauncherDiscoveryRequest must not be null");
        Preconditions.notNull(listeners, "TestExecutionListener array must not be null");
        Preconditions.containsNoNullElements(listeners, "individual listeners must not be null");
        this.execute(this.discoverRoot(discoveryRequest, "execution"), discoveryRequest.getConfigurationParameters(), listeners);
    }

    TestExecutionListenerRegistry getTestExecutionListenerRegistry() {
        return this.listenerRegistry;
    }

    private Root discoverRoot(LauncherDiscoveryRequest discoveryRequest, String phase) {
        Root root = new Root();
        for (TestEngine testEngine : this.testEngines) {
            boolean engineIsExcluded = discoveryRequest.getEngineFilters().stream().map(engineFilter -> engineFilter.apply(testEngine)).anyMatch(FilterResult::excluded);
            if (engineIsExcluded) {
                logger.fine(() -> String.format("Test discovery for engine '%s' was skipped due to an EngineFilter in phase '%s'.", testEngine.getId(), phase));
                continue;
            }
            logger.fine(() -> String.format("Discovering tests during Launcher %s phase in engine '%s'.", phase, testEngine.getId()));
            Optional<TestDescriptor> engineRoot = this.discoverEngineRoot(testEngine, discoveryRequest);
            engineRoot.ifPresent(rootDescriptor -> root.add(testEngine, (TestDescriptor)rootDescriptor));
        }
        root.applyPostDiscoveryFilters(discoveryRequest);
        root.prune();
        return root;
    }

    private Optional<TestDescriptor> discoverEngineRoot(TestEngine testEngine, LauncherDiscoveryRequest discoveryRequest) {
        UniqueId uniqueEngineId = UniqueId.forEngine(testEngine.getId());
        try {
            TestDescriptor engineRoot = testEngine.discover(discoveryRequest, uniqueEngineId);
            Preconditions.notNull(engineRoot, () -> String.format("The discover() method for TestEngine with ID '%s' must return a non-null root TestDescriptor.", testEngine.getId()));
            return Optional.of(engineRoot);
        }
        catch (Throwable throwable) {
            this.handleThrowable(testEngine, "discover", throwable);
            return Optional.empty();
        }
    }

    private void execute(Root root, ConfigurationParameters configurationParameters, TestExecutionListener ... listeners) {
        TestExecutionListenerRegistry listenerRegistry = this.buildListenerRegistryForExecution(listeners);
        TestPlan testPlan = TestPlan.from(root.getEngineDescriptors());
        TestExecutionListener testExecutionListener = listenerRegistry.getCompositeTestExecutionListener();
        testExecutionListener.testPlanExecutionStarted(testPlan);
        ExecutionListenerAdapter engineExecutionListener = new ExecutionListenerAdapter(testPlan, testExecutionListener);
        for (TestEngine testEngine : root.getTestEngines()) {
            TestDescriptor testDescriptor = root.getTestDescriptorFor(testEngine);
            this.execute(testEngine, new ExecutionRequest(testDescriptor, engineExecutionListener, configurationParameters));
        }
        testExecutionListener.testPlanExecutionFinished(testPlan);
    }

    private TestExecutionListenerRegistry buildListenerRegistryForExecution(TestExecutionListener ... listeners) {
        if (listeners.length == 0) {
            return this.listenerRegistry;
        }
        TestExecutionListenerRegistry registry = new TestExecutionListenerRegistry(this.listenerRegistry);
        registry.registerListeners(listeners);
        return registry;
    }

    private void execute(TestEngine testEngine, ExecutionRequest executionRequest) {
        try {
            testEngine.execute(executionRequest);
        }
        catch (Throwable throwable) {
            this.handleThrowable(testEngine, "execute", throwable);
        }
    }

    private void handleThrowable(TestEngine testEngine, String phase, Throwable throwable) {
        logger.log(Level.WARNING, throwable, () -> String.format("TestEngine with ID '%s' failed to %s tests", testEngine.getId(), phase));
        BlacklistedExceptions.rethrowIfBlacklisted(throwable);
    }
}

