/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.reporting;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(value=API.Usage.Experimental)
public final class ReportEntry {
    private final LocalDateTime timestamp = LocalDateTime.now();
    private final Map<String, String> keyValuePairs = new LinkedHashMap<String, String>();

    public static ReportEntry from(Map<String, String> keyValuePairs) {
        Preconditions.notNull(keyValuePairs, "keyValuePairs must not be null");
        ReportEntry reportEntry = new ReportEntry();
        keyValuePairs.forEach(reportEntry::add);
        return reportEntry;
    }

    public static ReportEntry from(String key, String value) {
        ReportEntry reportEntry = new ReportEntry();
        reportEntry.add(key, value);
        return reportEntry;
    }

    private void add(String key, String value) {
        Preconditions.notBlank(key, "key must not be null or blank");
        Preconditions.notBlank(value, "value must not be null or blank");
        this.keyValuePairs.put(key, value);
    }

    public final Map<String, String> getKeyValuePairs() {
        return Collections.unmodifiableMap(this.keyValuePairs);
    }

    public final LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.append("timestamp", this.timestamp);
        this.keyValuePairs.forEach(builder::append);
        return builder.toString();
    }
}

