/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.Color;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class VerboseTreePrintingListener
implements TestExecutionListener {
    private final PrintWriter out;
    private final boolean disableAnsiColors;
    private final Theme theme;
    private final Deque<Long> frames;
    private final String[] verticals;
    private long executionStartedMillis;

    VerboseTreePrintingListener(PrintWriter out, boolean disableAnsiColors, int maxContainerNestingLevel, Theme theme) {
        this.out = out;
        this.disableAnsiColors = disableAnsiColors;
        this.theme = theme;
        this.frames = new ArrayDeque<Long>();
        this.frames.push(0L);
        this.verticals = new String[Math.max(10, maxContainerNestingLevel) + 1];
        this.verticals[0] = "";
        this.verticals[1] = "";
        this.verticals[2] = "";
        for (int i = 3; i < this.verticals.length; ++i) {
            this.verticals[i] = this.verticals[i - 1] + theme.vertical();
        }
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.frames.push(System.currentTimeMillis());
        long tests = testPlan.countTestIdentifiers(TestIdentifier::isTest);
        this.printf(Color.NONE, "Test plan execution started. Number of static tests: ", new Object[0]);
        this.printf(Color.TEST, "%d%n", tests);
        this.printf(Color.CONTAINER, "%s%n", this.theme.root());
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.frames.pop();
        long tests = testPlan.countTestIdentifiers(TestIdentifier::isTest);
        this.printf(Color.NONE, "Test plan execution finished. Number of all tests: ", new Object[0]);
        this.printf(Color.TEST, "%d%n", tests);
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        this.executionStartedMillis = System.currentTimeMillis();
        if (testIdentifier.isContainer()) {
            this.printVerticals(this.theme.entry());
            this.printf(Color.CONTAINER, " %s", testIdentifier.getDisplayName());
            this.printf(Color.NONE, "%n", new Object[0]);
            this.frames.push(System.currentTimeMillis());
        }
        if (testIdentifier.isContainer()) {
            return;
        }
        this.printVerticals(this.theme.entry());
        this.printf(Color.valueOf(testIdentifier), " %s%n", testIdentifier.getDisplayName());
        this.printDetails(testIdentifier);
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isContainer()) {
            Long creationMillis = this.frames.pop();
            this.printVerticals(this.theme.end());
            this.printf(Color.CONTAINER, " %s", testIdentifier.getDisplayName());
            this.printf(Color.NONE, " finished after %d ms.%n", System.currentTimeMillis() - creationMillis);
            return;
        }
        testExecutionResult.getThrowable().ifPresent(t -> this.printDetail(Color.FAILED, "caught", ExceptionUtils.readStackTrace(t), new Object[0]));
        this.printDetail(Color.NONE, "duration", "%d ms%n", System.currentTimeMillis() - this.executionStartedMillis);
        String status = this.theme.status(testExecutionResult) + " " + (Object)((Object)testExecutionResult.getStatus());
        this.printDetail(Color.valueOf(testExecutionResult), "status", "%s%n", status);
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.printVerticals(this.theme.entry());
        this.printf(Color.valueOf(testIdentifier), " %s%n", testIdentifier.getDisplayName());
        this.printDetails(testIdentifier);
        this.printDetail(Color.SKIPPED, "reason", reason, new Object[0]);
        this.printDetail(Color.SKIPPED, "status", this.theme.skipped() + " SKIPPED", new Object[0]);
    }

    @Override
    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.printVerticals(this.theme.entry());
        this.printf(Color.DYNAMIC, " %s", testIdentifier.getDisplayName());
        this.printf(Color.NONE, " dynamically registered%n", new Object[0]);
    }

    @Override
    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.printDetail(Color.REPORTED, "reports", entry.toString(), new Object[0]);
    }

    private void printDetails(TestIdentifier testIdentifier) {
        this.printDetail(Color.NONE, "tags", "%s%n", testIdentifier.getTags());
        this.printDetail(Color.NONE, "uniqueId", "%s%n", testIdentifier.getUniqueId());
        this.printDetail(Color.NONE, "parent", "%s%n", testIdentifier.getParentId().orElse("[]"));
        testIdentifier.getSource().ifPresent(source -> this.printDetail(Color.NONE, "source", "%s%n", source));
    }

    private String verticals() {
        return this.verticals(this.frames.size());
    }

    private String verticals(int index) {
        return this.verticals[Math.min(index, this.verticals.length)];
    }

    private void printVerticals(String tile) {
        this.printf(Color.NONE, this.verticals(), new Object[0]);
        this.printf(Color.NONE, tile, new Object[0]);
    }

    private void printf(Color color, String message, Object ... args) {
        if (this.disableAnsiColors || color == Color.NONE) {
            this.out.printf(message, args);
        } else {
            this.out.printf((Object)((Object)color) + message + (Object)((Object)Color.NONE), args);
        }
        this.out.flush();
    }

    private void printDetail(Color color, String detail, String format, Object ... args) {
        String verticals = this.verticals(this.frames.size() + 1);
        this.printf(Color.NONE, verticals, new Object[0]);
        String detailFormat = "%9s";
        if (!detail.isEmpty()) {
            this.printf(Color.NONE, String.format(detailFormat + ": ", detail), new Object[0]);
        }
        if (args.length > 0) {
            this.printf(color, format, args);
            return;
        }
        String[] lines = format.split("\\R");
        this.printf(color, lines[0], new Object[0]);
        if (lines.length > 1) {
            String delimiter = System.lineSeparator() + verticals + String.format(detailFormat + "    ", "");
            for (int i = 1; i < lines.length; ++i) {
                this.printf(Color.NONE, delimiter, new Object[0]);
                this.printf(color, lines[i], new Object[0]);
            }
        }
        this.printf(Color.NONE, "%n", new Object[0]);
    }
}

