/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

class DiscoveryRequestCreator {
    DiscoveryRequestCreator() {
    }

    LauncherDiscoveryRequest toDiscoveryRequest(CommandLineOptions options) {
        LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request();
        requestBuilder.selectors(this.createDiscoverySelectors(options));
        this.addFilters(requestBuilder, options);
        requestBuilder.configurationParameters(options.getConfigurationParameters());
        return requestBuilder.build();
    }

    private List<? extends DiscoverySelector> createDiscoverySelectors(CommandLineOptions options) {
        if (options.isScanClasspath()) {
            Preconditions.condition(!options.hasExplicitSelectors(), "Scanning the classpath and using explicit selectors at the same time is not supported");
            return this.createClasspathRootSelectors(options);
        }
        return this.createExplicitDiscoverySelectors(options);
    }

    private List<ClasspathRootSelector> createClasspathRootSelectors(CommandLineOptions options) {
        Set<Path> classpathRoots = this.determineClasspathRoots(options);
        return DiscoverySelectors.selectClasspathRoots(classpathRoots);
    }

    private Set<Path> determineClasspathRoots(CommandLineOptions options) {
        if (options.getSelectedClasspathEntries().isEmpty()) {
            LinkedHashSet<Path> rootDirs = new LinkedHashSet<Path>(ReflectionUtils.getAllClasspathRootDirectories());
            rootDirs.addAll(options.getAdditionalClasspathEntries());
            return rootDirs;
        }
        return new LinkedHashSet<Path>(options.getSelectedClasspathEntries());
    }

    private List<DiscoverySelector> createExplicitDiscoverySelectors(CommandLineOptions options) {
        LinkedList<DiscoverySelector> selectors = new LinkedList<DiscoverySelector>();
        options.getSelectedUris().stream().map(DiscoverySelectors::selectUri).forEach(selectors::add);
        options.getSelectedFiles().stream().map(DiscoverySelectors::selectFile).forEach(selectors::add);
        options.getSelectedDirectories().stream().map(DiscoverySelectors::selectDirectory).forEach(selectors::add);
        options.getSelectedPackages().stream().map(DiscoverySelectors::selectPackage).forEach(selectors::add);
        options.getSelectedClasses().stream().map(DiscoverySelectors::selectClass).forEach(selectors::add);
        options.getSelectedMethods().stream().map(DiscoverySelectors::selectMethod).forEach(selectors::add);
        options.getSelectedClasspathResources().stream().map(DiscoverySelectors::selectClasspathResource).forEach(selectors::add);
        Preconditions.notEmpty(selectors, "No arguments were supplied to the ConsoleLauncher");
        return selectors;
    }

    private void addFilters(LauncherDiscoveryRequestBuilder requestBuilder, CommandLineOptions options) {
        requestBuilder.filters(ClassNameFilter.includeClassNamePatterns(options.getIncludedClassNamePatterns().toArray(new String[0])));
        if (!options.getExcludedClassNamePatterns().isEmpty()) {
            requestBuilder.filters(ClassNameFilter.excludeClassNamePatterns(options.getExcludedClassNamePatterns().toArray(new String[0])));
        }
        if (!options.getIncludedPackages().isEmpty()) {
            requestBuilder.filters(PackageNameFilter.includePackageNames(options.getIncludedPackages()));
        }
        if (!options.getExcludedPackages().isEmpty()) {
            requestBuilder.filters(PackageNameFilter.excludePackageNames(options.getExcludedPackages()));
        }
        if (!options.getIncludedTags().isEmpty()) {
            requestBuilder.filters(TagFilter.includeTags(options.getIncludedTags()));
        }
        if (!options.getExcludedTags().isEmpty()) {
            requestBuilder.filters(TagFilter.excludeTags(options.getExcludedTags()));
        }
        if (!options.getIncludedEngines().isEmpty()) {
            requestBuilder.filters(EngineFilter.includeEngines(options.getIncludedEngines()));
        }
        if (!options.getExcludedEngines().isEmpty()) {
            requestBuilder.filters(EngineFilter.excludeEngines(options.getExcludedEngines()));
        }
    }
}

