/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.TestExecutionResult;

@API(value=API.Usage.Internal)
public enum Theme {
    ASCII(".", "| ", "+--", "'--", "[OK]", "[A]", "[X]", "[S]"),
    UNICODE("\u2577", "\u2502  ", "\u251c\u2500", "\u2514\u2500", "\u2714", "\u25a0", "\u2718", "\u21b7");

    private final String[] tiles;
    private final String blank;

    public static Theme valueOf(Charset charset) {
        if (StandardCharsets.UTF_8.equals(charset)) {
            return UNICODE;
        }
        return ASCII;
    }

    private Theme(String ... tiles) {
        this.tiles = tiles;
        this.blank = new String(new char[this.vertical().length()]).replace('\u0000', ' ');
    }

    public final String root() {
        return this.tiles[0];
    }

    public final String vertical() {
        return this.tiles[1];
    }

    public final String blank() {
        return this.blank;
    }

    public final String entry() {
        return this.tiles[2];
    }

    public final String end() {
        return this.tiles[3];
    }

    public final String successful() {
        return this.tiles[4];
    }

    public final String aborted() {
        return this.tiles[5];
    }

    public final String failed() {
        return this.tiles[6];
    }

    public final String skipped() {
        return this.tiles[7];
    }

    public final String status(TestExecutionResult result) {
        switch (result.getStatus()) {
            case SUCCESSFUL: {
                return this.successful();
            }
            case ABORTED: {
                return this.aborted();
            }
            case FAILED: {
                return this.failed();
            }
        }
        return result.getStatus().name();
    }

    public final String toString() {
        return this.name().toLowerCase();
    }
}

