/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.execution.ConditionEvaluationException;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;

@API(value=API.Usage.Internal)
public class ConditionEvaluator {
    private static final Logger logger = Logger.getLogger(ConditionEvaluator.class.getName());
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled("No 'disabled' conditions encountered");
    private static final Predicate<Object> alwaysActivated = condition -> true;
    private static final Predicate<Object> alwaysDeactivated = condition -> false;

    public ConditionEvaluationResult evaluate(ExtensionRegistry extensionRegistry, ConfigurationParameters configurationParameters, ExtensionContext context) {
        return extensionRegistry.stream(ExecutionCondition.class).filter(this.conditionIsActivated(configurationParameters)).map(condition -> this.evaluate((ExecutionCondition)condition, context)).filter(ConditionEvaluationResult::isDisabled).findFirst().orElse(ENABLED);
    }

    private ConditionEvaluationResult evaluate(ExecutionCondition condition, ExtensionContext context) {
        try {
            ConditionEvaluationResult result = condition.evaluateExecutionCondition(context);
            this.logResult(condition.getClass(), result);
            return result;
        }
        catch (Exception ex) {
            throw this.evaluationException(condition.getClass(), ex);
        }
    }

    private void logResult(Class<?> conditionType, ConditionEvaluationResult result) {
        logger.finer(() -> String.format("Evaluation of condition [%s] resulted in: %s", conditionType.getName(), result));
    }

    private ConditionEvaluationException evaluationException(Class<?> conditionType, Exception ex) {
        String cause = StringUtils.isNotBlank(ex.getMessage()) ? ": " + ex.getMessage() : "";
        return new ConditionEvaluationException(String.format("Failed to evaluate condition [%s]%s", conditionType.getName(), cause), ex);
    }

    private Predicate<Object> conditionIsActivated(ConfigurationParameters configurationParameters) {
        String patternString = this.getDeactivatePatternString(configurationParameters);
        if (patternString != null) {
            if ("*".equals(patternString)) {
                return alwaysDeactivated;
            }
            Pattern pattern = Pattern.compile(this.convertToRegEx(patternString));
            return condition -> !pattern.matcher(condition.getClass().getName()).matches();
        }
        return alwaysActivated;
    }

    private String getDeactivatePatternString(ConfigurationParameters configurationParameters) {
        return configurationParameters.get("junit.jupiter.conditions.deactivate").filter(StringUtils::isNotBlank).map(String::trim).orElse(null);
    }

    private String convertToRegEx(String pattern) {
        pattern = Matcher.quoteReplacement(pattern);
        pattern = pattern.replace(".", "[.$]");
        pattern = pattern.replace("*", ".+");
        return pattern;
    }
}

