/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.execution;

import java.util.logging.Logger;
import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.runner.JUnitCore;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.execution.RunListenerAdapter;
import org.junit.vintage.engine.execution.TestRun;

@API(value=API.Usage.Internal)
public class RunnerExecutor {
    private final EngineExecutionListener engineExecutionListener;
    private final Logger logger;

    public RunnerExecutor(EngineExecutionListener engineExecutionListener, Logger logger) {
        this.engineExecutionListener = engineExecutionListener;
        this.logger = logger;
    }

    public void execute(RunnerTestDescriptor runnerTestDescriptor) {
        TestRun testRun = new TestRun(runnerTestDescriptor);
        JUnitCore core = new JUnitCore();
        core.addListener(new RunListenerAdapter(testRun, this.logger, this.engineExecutionListener));
        try {
            core.run(runnerTestDescriptor.toRequest());
        }
        catch (Throwable t) {
            this.reportUnexpectedFailure(testRun, runnerTestDescriptor, TestExecutionResult.failed(t));
        }
    }

    private void reportUnexpectedFailure(TestRun testRun, RunnerTestDescriptor runnerTestDescriptor, TestExecutionResult result) {
        if (testRun.isNotStarted(runnerTestDescriptor)) {
            this.engineExecutionListener.executionStarted(runnerTestDescriptor);
        }
        this.engineExecutionListener.executionFinished(runnerTestDescriptor, result);
    }
}

