/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;

@API(value=API.Usage.Experimental)
public final class TestIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String uniqueId;
    private final String parentId;
    private final String displayName;
    private final String legacyReportingName;
    private final TestSource source;
    private final Set<TestTag> tags;
    private final TestDescriptor.Type type;

    @API(value=API.Usage.Internal)
    public static TestIdentifier from(TestDescriptor testDescriptor) {
        Preconditions.notNull(testDescriptor, "TestDescriptor must not be null");
        String uniqueId = testDescriptor.getUniqueId().toString();
        String displayName = testDescriptor.getDisplayName();
        TestSource source = testDescriptor.getSource().orElse(null);
        Set<TestTag> tags = testDescriptor.getTags();
        TestDescriptor.Type type = testDescriptor.getType();
        String parentId = testDescriptor.getParent().map(parentDescriptor -> parentDescriptor.getUniqueId().toString()).orElse(null);
        String legacyReportingName = testDescriptor.getLegacyReportingName();
        return new TestIdentifier(uniqueId, displayName, source, tags, type, parentId, legacyReportingName);
    }

    TestIdentifier(String uniqueId, String displayName, TestSource source, Set<TestTag> tags, TestDescriptor.Type type, String parentId, String legacyReportingName) {
        Preconditions.notNull(type, "TestDescriptor.Type must not be null");
        this.uniqueId = uniqueId;
        this.parentId = parentId;
        this.displayName = displayName;
        this.source = source;
        this.tags = Collections.unmodifiableSet(new LinkedHashSet<TestTag>(tags));
        this.type = type;
        this.legacyReportingName = legacyReportingName;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public Optional<String> getParentId() {
        return Optional.ofNullable(this.parentId);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLegacyReportingName() {
        return this.legacyReportingName;
    }

    public TestDescriptor.Type getType() {
        return this.type;
    }

    public boolean isTest() {
        return this.getType().isTest();
    }

    public boolean isContainer() {
        return this.getType().isContainer();
    }

    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    public Set<TestTag> getTags() {
        return this.tags;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestIdentifier) {
            TestIdentifier that = (TestIdentifier)obj;
            return Objects.equals(this.uniqueId, that.uniqueId);
        }
        return false;
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("uniqueId", this.uniqueId).append("parentId", this.parentId).append("displayName", this.displayName).append("legacyReportingName", this.legacyReportingName).append("source", this.source).append("tags", this.tags).append("type", (Object)this.type).toString();
    }
}

