/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.platform.commons.meta.API;
import org.junit.platform.console.options.Details;
import org.junit.platform.console.options.Theme;

@API(value=API.Usage.Internal)
public class CommandLineOptions {
    static final Details DEFAULT_DETAILS = Details.TREE;
    static final Theme DEFAULT_THEME = Theme.valueOf(Charset.defaultCharset());
    private boolean displayHelp;
    private boolean ansiColorOutputDisabled;
    private Details details = DEFAULT_DETAILS;
    private Theme theme = DEFAULT_THEME;
    private boolean scanClasspath;
    private List<Path> selectedClasspathEntries = Collections.emptyList();
    private List<URI> selectedUris = Collections.emptyList();
    private List<String> selectedFiles = Collections.emptyList();
    private List<String> selectedDirectories = Collections.emptyList();
    private List<String> selectedPackages = Collections.emptyList();
    private List<String> selectedClasses = Collections.emptyList();
    private List<String> selectedMethods = Collections.emptyList();
    private List<String> selectedClasspathResources = Collections.emptyList();
    private List<String> includedClassNamePatterns = Collections.singletonList("^.*Tests?$");
    private List<String> excludedClassNamePatterns = Collections.emptyList();
    private List<String> includedPackages = Collections.emptyList();
    private List<String> excludedPackages = Collections.emptyList();
    private List<String> includedEngines = Collections.emptyList();
    private List<String> excludedEngines = Collections.emptyList();
    private List<String> includedTags = Collections.emptyList();
    private List<String> excludedTags = Collections.emptyList();
    private List<Path> additionalClasspathEntries = Collections.emptyList();
    private Path reportsDir;

    public boolean isDisplayHelp() {
        return this.displayHelp;
    }

    public void setDisplayHelp(boolean displayHelp) {
        this.displayHelp = displayHelp;
    }

    public boolean isAnsiColorOutputDisabled() {
        return this.ansiColorOutputDisabled;
    }

    public void setAnsiColorOutputDisabled(boolean ansiColorOutputDisabled) {
        this.ansiColorOutputDisabled = ansiColorOutputDisabled;
    }

    public boolean isScanClasspath() {
        return this.scanClasspath;
    }

    public void setScanClasspath(boolean scanClasspath) {
        this.scanClasspath = scanClasspath;
    }

    public Details getDetails() {
        return this.details;
    }

    public void setDetails(Details details) {
        this.details = details;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public List<URI> getSelectedUris() {
        return this.selectedUris;
    }

    public void setSelectedUris(List<URI> selectedUris) {
        this.selectedUris = selectedUris;
    }

    public List<String> getSelectedFiles() {
        return this.selectedFiles;
    }

    public void setSelectedFiles(List<String> selectedFiles) {
        this.selectedFiles = selectedFiles;
    }

    public List<String> getSelectedDirectories() {
        return this.selectedDirectories;
    }

    public void setSelectedDirectories(List<String> selectedDirectories) {
        this.selectedDirectories = selectedDirectories;
    }

    public List<String> getSelectedPackages() {
        return this.selectedPackages;
    }

    public void setSelectedPackages(List<String> selectedPackages) {
        this.selectedPackages = selectedPackages;
    }

    public List<String> getSelectedClasses() {
        return this.selectedClasses;
    }

    public void setSelectedClasses(List<String> selectedClasses) {
        this.selectedClasses = selectedClasses;
    }

    public List<String> getSelectedMethods() {
        return this.selectedMethods;
    }

    public void setSelectedMethods(List<String> selectedMethods) {
        this.selectedMethods = selectedMethods;
    }

    public List<String> getSelectedClasspathResources() {
        return this.selectedClasspathResources;
    }

    public void setSelectedClasspathResources(List<String> selectedClasspathResources) {
        this.selectedClasspathResources = selectedClasspathResources;
    }

    public boolean hasExplicitSelectors() {
        return Stream.of(this.selectedUris, this.selectedFiles, this.selectedDirectories, this.selectedPackages, this.selectedClasses, this.selectedMethods, this.selectedClasspathResources).anyMatch(selectors -> !selectors.isEmpty());
    }

    public List<String> getIncludedClassNamePatterns() {
        return this.includedClassNamePatterns;
    }

    public void setIncludedClassNamePatterns(List<String> includedClassNamePatterns) {
        this.includedClassNamePatterns = includedClassNamePatterns;
    }

    public List<String> getExcludedClassNamePatterns() {
        return this.excludedClassNamePatterns;
    }

    public void setExcludedClassNamePatterns(List<String> excludedClassNamePatterns) {
        this.excludedClassNamePatterns = excludedClassNamePatterns;
    }

    public List<String> getIncludedPackages() {
        return this.includedPackages;
    }

    public void setIncludedPackages(List<String> includedPackages) {
        this.includedPackages = includedPackages;
    }

    public List<String> getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(List<String> excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public List<String> getIncludedEngines() {
        return this.includedEngines;
    }

    public void setIncludedEngines(List<String> includedEngines) {
        this.includedEngines = includedEngines;
    }

    public List<String> getExcludedEngines() {
        return this.excludedEngines;
    }

    public void setExcludedEngines(List<String> excludedEngines) {
        this.excludedEngines = excludedEngines;
    }

    public List<String> getIncludedTags() {
        return this.includedTags;
    }

    public void setIncludedTags(List<String> includedTags) {
        this.includedTags = includedTags;
    }

    public List<String> getExcludedTags() {
        return this.excludedTags;
    }

    public void setExcludedTags(List<String> excludedTags) {
        this.excludedTags = excludedTags;
    }

    public List<Path> getAdditionalClasspathEntries() {
        return this.additionalClasspathEntries;
    }

    public void setAdditionalClasspathEntries(List<Path> additionalClasspathEntries) {
        this.additionalClasspathEntries = new ArrayList<Path>(additionalClasspathEntries);
        this.additionalClasspathEntries.removeIf(path -> !Files.exists(path, new LinkOption[0]));
    }

    public Optional<Path> getReportsDir() {
        return Optional.ofNullable(this.reportsDir);
    }

    public void setReportsDir(Path reportsDir) {
        this.reportsDir = reportsDir;
    }

    public List<Path> getSelectedClasspathEntries() {
        return this.selectedClasspathEntries;
    }

    public void setSelectedClasspathEntries(List<Path> selectedClasspathEntries) {
        this.selectedClasspathEntries = selectedClasspathEntries;
    }
}

