/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvFormat;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParser;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParserSettings;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.util.Preconditions;

class CsvFileArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<CsvFileSource> {
    private final BiFunction<Class<?>, String, InputStream> inputStreamProvider;
    private String[] resources;
    private Charset charset;
    private CsvParserSettings settings;

    CsvFileArgumentsProvider() {
        this(Class::getResourceAsStream);
    }

    CsvFileArgumentsProvider(BiFunction<Class<?>, String, InputStream> inputStreamProvider) {
        this.inputStreamProvider = inputStreamProvider;
    }

    @Override
    public void accept(CsvFileSource annotation) {
        this.resources = annotation.resources();
        this.charset = Charset.forName(annotation.encoding());
        this.settings = new CsvParserSettings();
        ((CsvFormat)this.settings.getFormat()).setDelimiter(annotation.delimiter());
        ((CsvFormat)this.settings.getFormat()).setLineSeparator(annotation.lineSeparator());
        this.settings.setAutoConfigurationEnabled(false);
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        return Arrays.stream(this.resources).map(resource -> this.openInputStream(context, (String)resource)).map(this::createCsvParser).flatMap(this::toStream);
    }

    private InputStream openInputStream(ExtensionContext context, String resource) {
        Class<?> testClass = context.getRequiredTestClass();
        return Preconditions.notNull(this.inputStreamProvider.apply(testClass, resource), () -> "Classpath resource does not exist: " + resource);
    }

    private CsvParser createCsvParser(InputStream inputStream) {
        CsvParser csvParser = new CsvParser(this.settings);
        csvParser.beginParsing(inputStream, this.charset);
        return csvParser;
    }

    private Stream<Arguments> toStream(CsvParser csvParser) {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(new CsvParserIterator(csvParser), 16), false).onClose(csvParser::stopParsing);
    }

    private static class CsvParserIterator
    implements Iterator<Arguments> {
        private final CsvParser csvParser;
        private Object[] nextCsvRecord;

        CsvParserIterator(CsvParser csvParser) {
            this.csvParser = csvParser;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextCsvRecord != null;
        }

        @Override
        public Arguments next() {
            Arguments result = Arguments.of(this.nextCsvRecord);
            this.advance();
            return result;
        }

        private void advance() {
            this.nextCsvRecord = this.csvParser.parseNext();
        }
    }
}

