/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;

@API(value=API.Usage.Experimental)
public final class DiscoverySelectors {
    private static final Pattern fullyQualifiedMethodNamePattern = Pattern.compile("([^#]+)#([^(]+)(?:\\((.*)\\))?");

    private DiscoverySelectors() {
    }

    public static UriSelector selectUri(String uri) {
        Preconditions.notBlank(uri, "URI must not be null or blank");
        try {
            return new UriSelector(new URI(uri));
        }
        catch (URISyntaxException ex) {
            throw new PreconditionViolationException("Failed to create a java.net.URI from: " + uri, ex);
        }
    }

    public static UriSelector selectUri(URI uri) {
        Preconditions.notNull(uri, "URI must not be null");
        return new UriSelector(uri);
    }

    public static FileSelector selectFile(String path) {
        Preconditions.notBlank(path, "File path must not be null or blank");
        return new FileSelector(path);
    }

    public static FileSelector selectFile(File file) {
        Preconditions.notNull(file, "File must not be null");
        Preconditions.condition(file.isFile(), () -> String.format("The supplied java.io.File [%s] must represent an existing file", file));
        try {
            return new FileSelector(file.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new PreconditionViolationException("Failed to retrieve canonical path for file: " + file, ex);
        }
    }

    public static DirectorySelector selectDirectory(String path) {
        Preconditions.notBlank(path, "Directory path must not be null or blank");
        return new DirectorySelector(path);
    }

    public static DirectorySelector selectDirectory(File directory) {
        Preconditions.notNull(directory, "Directory must not be null");
        Preconditions.condition(directory.isDirectory(), () -> String.format("The supplied java.io.File [%s] must represent an existing directory", directory));
        try {
            return new DirectorySelector(directory.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new PreconditionViolationException("Failed to retrieve canonical path for directory: " + directory, ex);
        }
    }

    public static List<ClasspathRootSelector> selectClasspathRoots(Set<Path> classpathRoots) {
        Preconditions.notNull(classpathRoots, "classpathRoots must not be null");
        return classpathRoots.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toUri).map(ClasspathRootSelector::new).collect(CollectionUtils.toUnmodifiableList());
    }

    public static ClasspathResourceSelector selectClasspathResource(String classpathResourceName) {
        Preconditions.notBlank(classpathResourceName, "Classpath resource name must not be null or blank");
        return new ClasspathResourceSelector(classpathResourceName);
    }

    public static PackageSelector selectPackage(String packageName) {
        Preconditions.notNull(packageName, "Package name must not be null");
        Preconditions.condition(packageName.isEmpty() || !packageName.trim().isEmpty(), "Package name must not contain only whitespace");
        return new PackageSelector(packageName.trim());
    }

    public static ClassSelector selectClass(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return new ClassSelector(clazz);
    }

    public static ClassSelector selectClass(String className) {
        Preconditions.notBlank(className, "Class name must not be null or blank");
        return new ClassSelector(className);
    }

    public static MethodSelector selectMethod(String fullyQualifiedMethodName) throws PreconditionViolationException {
        Preconditions.notBlank(fullyQualifiedMethodName, "fullyQualifiedMethodName must not be null or blank");
        Matcher matcher = fullyQualifiedMethodNamePattern.matcher(fullyQualifiedMethodName);
        Preconditions.condition(matcher.matches(), fullyQualifiedMethodName + " is not a valid fully qualified method name");
        String className = matcher.group(1);
        String methodName = matcher.group(2);
        String methodParameters = matcher.group(3);
        if (StringUtils.isNotBlank(methodParameters)) {
            return DiscoverySelectors.selectMethod(className, methodName, methodParameters);
        }
        return DiscoverySelectors.selectMethod(className, methodName);
    }

    public static MethodSelector selectMethod(String className, String methodName) {
        Preconditions.notBlank(className, "Class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return new MethodSelector(className, methodName);
    }

    public static MethodSelector selectMethod(String className, String methodName, String methodParameterTypes) {
        Preconditions.notBlank(className, "Class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(methodParameterTypes, "Parameter types must not be null");
        return new MethodSelector(className, methodName, methodParameterTypes.trim());
    }

    public static MethodSelector selectMethod(Class<?> javaClass, String methodName) {
        Preconditions.notNull(javaClass, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return new MethodSelector(javaClass, methodName);
    }

    public static MethodSelector selectMethod(Class<?> javaClass, String methodName, String methodParameterTypes) {
        Preconditions.notNull(javaClass, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(methodParameterTypes, "Parameter types must not be null");
        return new MethodSelector(javaClass, methodName, methodParameterTypes.trim());
    }

    public static MethodSelector selectMethod(Class<?> javaClass, Method method) {
        Preconditions.notNull(javaClass, "Class must not be null");
        Preconditions.notNull(method, "Method must not be null");
        return new MethodSelector(javaClass, method);
    }

    public static UniqueIdSelector selectUniqueId(UniqueId uniqueId) {
        Preconditions.notNull(uniqueId, "UniqueId must not be null");
        return new UniqueIdSelector(uniqueId);
    }

    public static UniqueIdSelector selectUniqueId(String uniqueId) {
        Preconditions.notBlank(uniqueId, "Unique ID must not be null or blank");
        return new UniqueIdSelector(UniqueId.parse(uniqueId));
    }
}

