/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.lang.reflect.Method;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.RunnerTestDescriptorAwareFilter;
import org.junit.vintage.engine.discovery.TestClassCollector;

class MethodSelectorResolver
implements DiscoverySelectorResolver {
    MethodSelectorResolver() {
    }

    @Override
    public void resolve(EngineDiscoveryRequest request, TestClassCollector collector) {
        request.getSelectorsByType(MethodSelector.class).forEach(selector -> this.resolve((MethodSelector)selector, collector));
    }

    private void resolve(MethodSelector selector, TestClassCollector collector) {
        Class<?> testClass = selector.getJavaClass();
        Method testMethod = selector.getJavaMethod();
        Description methodDescription = Description.createTestDescription(testClass, testMethod.getName());
        collector.addFiltered(testClass, RunnerTestDescriptorAwareFilter.adapter(Filter.matchMethodDescription(methodDescription)));
    }
}

