/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.Collection;
import java.util.function.Predicate;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.vintage.engine.discovery.DiscoverySelectorResolver;
import org.junit.vintage.engine.discovery.TestClassCollector;

class ClasspathRootSelectorResolver
implements DiscoverySelectorResolver {
    private final Predicate<String> classNamePredicate;

    ClasspathRootSelectorResolver(Predicate<String> classNamePredicate) {
        this.classNamePredicate = classNamePredicate;
    }

    @Override
    public void resolve(EngineDiscoveryRequest request, TestClassCollector collector) {
        request.getSelectorsByType(ClasspathRootSelector.class).stream().map(ClasspathRootSelector::getClasspathRoot).map(root -> ReflectionUtils.findAllClassesInClasspathRoot(root, classTester, this.classNamePredicate)).flatMap(Collection::stream).forEach(collector::addCompletely);
    }
}

