/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;

@API(value=API.Usage.Internal)
enum Color {
    NONE(0),
    BLACK(30),
    RED(31),
    GREEN(32),
    YELLOW(33),
    BLUE(34),
    PURPLE(35),
    CYAN(36),
    WHITE(37);

    static final Color SUCCESSFUL;
    static final Color ABORTED;
    static final Color FAILED;
    static final Color SKIPPED;
    static final Color CONTAINER;
    static final Color TEST;
    static final Color DYNAMIC;
    static final Color REPORTED;
    private final String ansiString;

    static Color valueOf(TestExecutionResult result) {
        switch (result.getStatus()) {
            case SUCCESSFUL: {
                return SUCCESSFUL;
            }
            case ABORTED: {
                return ABORTED;
            }
            case FAILED: {
                return FAILED;
            }
        }
        return NONE;
    }

    static Color valueOf(TestIdentifier testIdentifier) {
        return testIdentifier.isContainer() ? CONTAINER : TEST;
    }

    private Color(int ansiCode) {
        this.ansiString = "\u001b[" + ansiCode + "m";
    }

    public String toString() {
        return this.ansiString;
    }

    static {
        SUCCESSFUL = GREEN;
        ABORTED = YELLOW;
        FAILED = RED;
        SKIPPED = PURPLE;
        CONTAINER = CYAN;
        TEST = BLUE;
        DYNAMIC = PURPLE;
        REPORTED = WHITE;
    }
}

