/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.junit.platform.commons.meta.API;
import org.junit.platform.console.ConsoleLauncherExecutionResult;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.CommandLineOptionsParser;
import org.junit.platform.console.options.JOptSimpleCommandLineOptionsParser;
import org.junit.platform.console.tasks.ConsoleTestExecutor;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@API(value=API.Usage.Maintained)
public class ConsoleLauncher {
    private final CommandLineOptionsParser commandLineOptionsParser;
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final Charset charset;

    @API(value=API.Usage.Maintained)
    public static void main(String ... args) {
        int exitCode = ConsoleLauncher.execute(System.out, System.err, args).getExitCode();
        System.exit(exitCode);
    }

    @API(value=API.Usage.Internal)
    public static ConsoleLauncherExecutionResult execute(PrintStream out, PrintStream err, String ... args) {
        JOptSimpleCommandLineOptionsParser parser = new JOptSimpleCommandLineOptionsParser();
        ConsoleLauncher consoleLauncher = new ConsoleLauncher(parser, out, err);
        return consoleLauncher.execute(args);
    }

    ConsoleLauncher(CommandLineOptionsParser commandLineOptionsParser, PrintStream out, PrintStream err) {
        this(commandLineOptionsParser, out, err, Charset.defaultCharset());
    }

    ConsoleLauncher(CommandLineOptionsParser commandLineOptionsParser, PrintStream out, PrintStream err, Charset charset) {
        this.commandLineOptionsParser = commandLineOptionsParser;
        this.outStream = out;
        this.errStream = err;
        this.charset = charset;
    }

    /*
     * Loose catch block
     */
    ConsoleLauncherExecutionResult execute(String ... args) {
        CommandLineOptions options = this.commandLineOptionsParser.parse(args);
        try {
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)this.outStream, this.charset)));){
                if (options.isDisplayHelp()) {
                    this.commandLineOptionsParser.printHelp(out);
                    ConsoleLauncherExecutionResult consoleLauncherExecutionResult = ConsoleLauncherExecutionResult.success();
                    return consoleLauncherExecutionResult;
                }
                ConsoleLauncherExecutionResult consoleLauncherExecutionResult = this.executeTests(options, out);
                return consoleLauncherExecutionResult;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.outStream.flush();
            this.errStream.flush();
        }
    }

    private ConsoleLauncherExecutionResult executeTests(CommandLineOptions options, PrintWriter out) {
        try {
            TestExecutionSummary testExecutionSummary = new ConsoleTestExecutor(options).execute(out);
            return ConsoleLauncherExecutionResult.forSummary(testExecutionSummary);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.errStream);
            this.errStream.println();
            this.commandLineOptionsParser.printHelp(out);
            return ConsoleLauncherExecutionResult.failed();
        }
    }
}

