/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.platform.commons.meta.API;

@API(value=API.Usage.Internal)
public final class ClassUtils {
    private ClassUtils() {
    }

    public static String nullSafeToString(Class<?> ... classes) {
        return ClassUtils.nullSafeToString(Class::getName, classes);
    }

    public static String nullSafeToString(Function<? super Class<?>, ? extends String> mapper, Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            return "";
        }
        return Arrays.stream(classes).map(v -> v == null ? "null" : (String)mapper.apply((Class<?>)v)).collect(Collectors.joining(", "));
    }
}

