/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.text.MessageFormat;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedTestNameFormatter {
    private final String namePattern;

    ParameterizedTestNameFormatter(String namePattern) {
        this.namePattern = namePattern;
    }

    String format(int invocationIndex, Object ... arguments) {
        String pattern = this.prepareMessageFormatPattern(invocationIndex, arguments);
        Object[] humanReadableArguments = this.makeReadable(arguments);
        return this.formatSafely(pattern, humanReadableArguments);
    }

    private String prepareMessageFormatPattern(int invocationIndex, Object[] arguments) {
        String result = this.namePattern.replace("{index}", String.valueOf(invocationIndex));
        if (result.contains("{arguments}")) {
            String replacement = IntStream.range(0, arguments.length).mapToObj(index -> "{" + index + "}").collect(Collectors.joining(", "));
            result = result.replace("{arguments}", replacement);
        }
        return result;
    }

    private Object[] makeReadable(Object[] arguments) {
        Object[] humanReadableArguments = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            humanReadableArguments[i] = StringUtils.nullSafeToString(arguments[i]);
        }
        return humanReadableArguments;
    }

    private String formatSafely(String pattern, Object[] arguments) {
        try {
            return MessageFormat.format(pattern, arguments);
        }
        catch (IllegalArgumentException ex) {
            String message = "The naming pattern defined for the parameterized tests is invalid. The nested exception contains more details.";
            throw new JUnitException(message, ex);
        }
    }
}

