/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(value=API.Usage.Internal)
public class ExtensionValuesStore {
    private final ExtensionValuesStore parentStore;
    private final Map<Object, StoredValue> storedValues = new HashMap<Object, StoredValue>(4);
    private final Object monitor = new Object();

    ExtensionValuesStore() {
        this(null);
    }

    public ExtensionValuesStore(ExtensionValuesStore parentStore) {
        this.parentStore = parentStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object get(ExtensionContext.Namespace namespace, Object key) {
        Object object = this.monitor;
        synchronized (object) {
            StoredValue storedValue = this.getStoredValue(namespace, key);
            if (storedValue != null) {
                return storedValue.value;
            }
            if (this.parentStore != null) {
                return this.parentStore.get(namespace, key);
            }
            return null;
        }
    }

    <T> T get(ExtensionContext.Namespace namespace, Object key, Class<T> requiredType) {
        Object value = this.get(namespace, key);
        return this.castToRequiredType(key, value, requiredType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <K, V> Object getOrComputeIfAbsent(ExtensionContext.Namespace namespace, K key, Function<K, V> defaultCreator) {
        Object object = this.monitor;
        synchronized (object) {
            StoredValue storedValue = this.getStoredValue(namespace, key);
            if (storedValue == null) {
                if (this.parentStore != null) {
                    storedValue = this.parentStore.getStoredValue(namespace, key);
                }
                if (storedValue == null) {
                    storedValue = new StoredValue(defaultCreator.apply(key));
                    this.putStoredValue(namespace, key, storedValue);
                }
            }
            return storedValue.value;
        }
    }

    <K, V> V getOrComputeIfAbsent(ExtensionContext.Namespace namespace, K key, Function<K, V> defaultCreator, Class<V> requiredType) {
        Object value = this.getOrComputeIfAbsent(namespace, key, defaultCreator);
        return this.castToRequiredType(key, value, requiredType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(ExtensionContext.Namespace namespace, Object key, Object value) {
        Preconditions.notNull(namespace, "Namespace must not be null");
        Preconditions.notNull(key, "key must not be null");
        Object object = this.monitor;
        synchronized (object) {
            this.putStoredValue(namespace, key, new StoredValue(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object remove(ExtensionContext.Namespace namespace, Object key) {
        Object object = this.monitor;
        synchronized (object) {
            StoredValue previous = this.storedValues.remove(new CompositeKey(namespace, key));
            return previous != null ? previous.value : null;
        }
    }

    <T> T remove(ExtensionContext.Namespace namespace, Object key, Class<T> requiredType) {
        Object value = this.remove(namespace, key);
        return this.castToRequiredType(key, value, requiredType);
    }

    private StoredValue getStoredValue(ExtensionContext.Namespace namespace, Object key) {
        CompositeKey compositeKey = new CompositeKey(namespace, key);
        return this.storedValues.get(compositeKey);
    }

    private void putStoredValue(ExtensionContext.Namespace namespace, Object key, StoredValue storedValue) {
        CompositeKey compositeKey = new CompositeKey(namespace, key);
        this.storedValues.put(compositeKey, storedValue);
    }

    private <T> T castToRequiredType(Object key, Object value, Class<T> requiredType) {
        if (value == null) {
            return null;
        }
        if (ReflectionUtils.isAssignableTo(value, requiredType)) {
            if (requiredType.isPrimitive()) {
                return (T)ReflectionUtils.getWrapperType(requiredType).cast(value);
            }
            return requiredType.cast(value);
        }
        throw new ExtensionContextException(String.format("Object stored under key [%s] is not of required type [%s]", key, requiredType.getName()));
    }

    private static class StoredValue {
        private final Object value;

        private StoredValue(Object value) {
            this.value = value;
        }
    }

    private static class CompositeKey {
        private final ExtensionContext.Namespace namespace;
        private final Object key;

        private CompositeKey(ExtensionContext.Namespace namespace, Object key) {
            this.namespace = namespace;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            return this.namespace.equals(that.namespace) && this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.key);
        }
    }
}

