/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.LinkedHashSet;
import java.util.function.Predicate;
import org.junit.jupiter.engine.discovery.ElementResolver;
import org.junit.jupiter.engine.discovery.JavaElementsResolver;
import org.junit.jupiter.engine.discovery.NestedTestsResolver;
import org.junit.jupiter.engine.discovery.TestContainerResolver;
import org.junit.jupiter.engine.discovery.TestFactoryMethodResolver;
import org.junit.jupiter.engine.discovery.TestMethodResolver;
import org.junit.jupiter.engine.discovery.TestTemplateMethodResolver;
import org.junit.jupiter.engine.discovery.predicates.IsScannableTestClass;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.filter.ClasspathScanningSupport;

@API(value=API.Usage.Internal)
public class DiscoverySelectorResolver {
    private static final IsScannableTestClass isScannableTestClass = new IsScannableTestClass();

    public void resolveSelectors(EngineDiscoveryRequest request, TestDescriptor engineDescriptor) {
        JavaElementsResolver javaElementsResolver = this.createJavaElementsResolver(engineDescriptor);
        Predicate<String> classNamePredicate = ClasspathScanningSupport.buildClassNamePredicate(request);
        request.getSelectorsByType(ClasspathRootSelector.class).forEach(selector -> ReflectionUtils.findAllClassesInClasspathRoot(selector.getClasspathRoot(), isScannableTestClass, classNamePredicate).forEach(javaElementsResolver::resolveClass));
        request.getSelectorsByType(PackageSelector.class).forEach(selector -> ReflectionUtils.findAllClassesInPackage(selector.getPackageName(), isScannableTestClass, classNamePredicate).forEach(javaElementsResolver::resolveClass));
        request.getSelectorsByType(ClassSelector.class).forEach(selector -> javaElementsResolver.resolveClass(selector.getJavaClass()));
        request.getSelectorsByType(MethodSelector.class).forEach(selector -> javaElementsResolver.resolveMethod(selector.getJavaClass(), selector.getJavaMethod()));
        request.getSelectorsByType(UniqueIdSelector.class).forEach(selector -> javaElementsResolver.resolveUniqueId(selector.getUniqueId()));
        this.pruneTree(engineDescriptor);
    }

    private void pruneTree(TestDescriptor rootDescriptor) {
        rootDescriptor.accept(TestDescriptor::prune);
    }

    private JavaElementsResolver createJavaElementsResolver(TestDescriptor engineDescriptor) {
        LinkedHashSet<ElementResolver> resolvers = new LinkedHashSet<ElementResolver>();
        resolvers.add(new TestContainerResolver());
        resolvers.add(new NestedTestsResolver());
        resolvers.add(new TestMethodResolver());
        resolvers.add(new TestFactoryMethodResolver());
        resolvers.add(new TestTemplateMethodResolver());
        return new JavaElementsResolver(engineDescriptor, resolvers);
    }
}

