/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestFactoryTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

class DynamicContainerTestDescriptor
extends JupiterTestDescriptor {
    private final DynamicContainer dynamicContainer;
    private final TestSource testSource;

    DynamicContainerTestDescriptor(UniqueId uniqueId, DynamicContainer dynamicContainer, TestSource testSource) {
        super(uniqueId, dynamicContainer.getDisplayName(), testSource);
        this.dynamicContainer = dynamicContainer;
        this.testSource = testSource;
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public Node.SkipResult shouldBeSkipped(JupiterEngineExecutionContext context) throws Exception {
        return Node.SkipResult.doNotSkip();
    }

    @Override
    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        AtomicInteger index = new AtomicInteger(1);
        try (Stream<? extends DynamicNode> children = this.dynamicContainer.getChildren();){
            children.peek(child -> Preconditions.notNull(child, "individual dynamic node must not be null")).map(child -> this.toDynamicDescriptor(index.getAndIncrement(), (DynamicNode)child)).forEachOrdered(dynamicTestExecutor::execute);
        }
        return context;
    }

    private JupiterTestDescriptor toDynamicDescriptor(int index, DynamicNode childNode) {
        return TestFactoryTestDescriptor.createDynamicDescriptor(this, childNode, index, this.testSource);
    }
}

