/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.execution;

import java.util.Optional;
import java.util.function.Function;
import org.junit.Ignore;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.execution.TestRun;

class RunListenerAdapter
extends RunListener {
    private final TestRun testRun;
    private final EngineExecutionListener listener;

    RunListenerAdapter(TestRun testRun, EngineExecutionListener listener) {
        this.testRun = testRun;
        this.listener = listener;
    }

    @Override
    public void testRunStarted(Description description) {
        if (description.isSuite()) {
            this.fireExecutionStarted(this.testRun.getRunnerTestDescriptor());
        }
    }

    @Override
    public void testIgnored(Description description) {
        this.testRun.lookupTestDescriptor(description).ifPresent(testDescriptor -> this.testIgnored((TestDescriptor)testDescriptor, this.determineReasonForIgnoredTest(description)));
    }

    @Override
    public void testStarted(Description description) {
        this.testRun.lookupTestDescriptor(description).ifPresent(this::testStarted);
    }

    @Override
    public void testAssumptionFailure(Failure failure) {
        this.handleFailure(failure, TestExecutionResult::aborted);
    }

    @Override
    public void testFailure(Failure failure) {
        this.handleFailure(failure, TestExecutionResult::failed);
    }

    @Override
    public void testFinished(Description description) {
        this.testRun.lookupTestDescriptor(description).ifPresent(this::testFinished);
    }

    @Override
    public void testRunFinished(Result result) {
        RunnerTestDescriptor runnerTestDescriptor = this.testRun.getRunnerTestDescriptor();
        if (this.testRun.isNotSkipped(runnerTestDescriptor)) {
            if (this.testRun.isNotStarted(runnerTestDescriptor)) {
                this.fireExecutionStarted(runnerTestDescriptor);
            }
            this.fireExecutionFinished(runnerTestDescriptor);
        }
    }

    private void handleFailure(Failure failure, Function<Throwable, TestExecutionResult> resultCreator) {
        this.testRun.lookupTestDescriptor(failure.getDescription()).ifPresent(testDescriptor -> this.handleFailure(failure, resultCreator, (TestDescriptor)testDescriptor));
    }

    private void handleFailure(Failure failure, Function<Throwable, TestExecutionResult> resultCreator, TestDescriptor testDescriptor) {
        TestExecutionResult result = resultCreator.apply(failure.getException());
        this.testRun.storeResult(testDescriptor, result);
        if (testDescriptor.isContainer() && this.testRun.isDescendantOfRunnerTestDescriptor(testDescriptor)) {
            this.fireMissingContainerEvents(testDescriptor);
        }
    }

    private void fireMissingContainerEvents(TestDescriptor testDescriptor) {
        if (this.testRun.isNotStarted(testDescriptor)) {
            this.testStarted(testDescriptor);
        }
        if (this.testRun.isNotFinished(testDescriptor)) {
            this.testFinished(testDescriptor);
        }
    }

    private void testIgnored(TestDescriptor testDescriptor, String reason) {
        this.fireExecutionStartedIncludingUnstartedAncestors(testDescriptor.getParent());
        this.fireExecutionSkipped(testDescriptor, reason);
        this.fireExecutionFinishedIncludingAncestorsWithoutPendingChildren(testDescriptor.getParent());
    }

    private String determineReasonForIgnoredTest(Description description) {
        Ignore ignoreAnnotation = description.getAnnotation(Ignore.class);
        return Optional.ofNullable(ignoreAnnotation).map(Ignore::value).orElse("<unknown>");
    }

    private void testStarted(TestDescriptor testDescriptor) {
        this.fireExecutionStartedIncludingUnstartedAncestors(testDescriptor.getParent());
        this.fireExecutionStarted(testDescriptor);
    }

    private void testFinished(TestDescriptor descriptor) {
        this.fireExecutionFinished(descriptor);
        this.fireExecutionFinishedIncludingAncestorsWithoutPendingChildren(descriptor.getParent());
    }

    private void fireExecutionStartedIncludingUnstartedAncestors(Optional<TestDescriptor> parent) {
        if (parent.isPresent() && this.canStart(parent.get())) {
            this.fireExecutionStartedIncludingUnstartedAncestors(parent.get().getParent());
            this.fireExecutionStarted(parent.get());
        }
    }

    private void fireExecutionFinishedIncludingAncestorsWithoutPendingChildren(Optional<TestDescriptor> parent) {
        if (parent.isPresent() && this.canFinish(parent.get())) {
            this.fireExecutionFinished(parent.get());
            this.fireExecutionFinishedIncludingAncestorsWithoutPendingChildren(parent.get().getParent());
        }
    }

    private boolean canStart(TestDescriptor testDescriptor) {
        return this.testRun.isNotStarted(testDescriptor) && this.testRun.isDescendantOfRunnerTestDescriptor(testDescriptor);
    }

    private boolean canFinish(TestDescriptor testDescriptor) {
        return this.testRun.isNotFinished(testDescriptor) && this.testRun.isDescendantOfRunnerTestDescriptor(testDescriptor) && this.testRun.areAllFinishedOrSkipped(testDescriptor.getChildren());
    }

    private void fireExecutionSkipped(TestDescriptor testDescriptor, String reason) {
        this.testRun.markSkipped(testDescriptor);
        this.listener.executionSkipped(testDescriptor, reason);
    }

    private void fireExecutionStarted(TestDescriptor testDescriptor) {
        this.testRun.markStarted(testDescriptor);
        this.listener.executionStarted(testDescriptor);
    }

    private void fireExecutionFinished(TestDescriptor testDescriptor) {
        this.testRun.markFinished(testDescriptor);
        this.listener.executionFinished(testDescriptor, this.testRun.getStoredResultOrSuccessful(testDescriptor));
    }
}

